/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.dialog.LoginDialog;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.auth.ClientLoginListener;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;

public class Authenticator
implements AuthenticationRequestListener {
    private boolean hasBeenAuthenticatedBefore = false;
    private boolean previousAttemptSuccessful = true;
    private ClientLoginListener loginListener = null;

    @Override
    public void setLoginListener(ClientLoginListener listener) {
        this.loginListener = listener;
    }

    @Override
    public AuthenticationRequestListener.Credentials authenticationRequest() {
        final CredentialsHolder credentialsHolder = new CredentialsHolder();
        final CountDownLatch loginLatch = new CountDownLatch(1);
        LoginCallback callback = new LoginCallback(){

            @Override
            public boolean authenticate(String username, String password) {
                credentialsHolder.credentials = new AuthenticationRequestListener.Credentials(username, new String(password));
                loginLatch.countDown();
                return true;
            }
        };
        if (this.previousAttemptSuccessful) {
            this.previousAttemptSuccessful = false;
            new LoginDialog(callback).setVisible(true);
        } else {
            new LoginDialog(callback, true).setVisible(true);
        }
        try {
            loginLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return credentialsHolder.credentials;
    }

    @Override
    public void authenticationSucceeded() {
        if (!this.hasBeenAuthenticatedBefore) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Authenticator.this.loginListener.firstLogin();
                }
            });
            this.hasBeenAuthenticatedBefore = true;
        }
        this.previousAttemptSuccessful = true;
    }

    public static interface LoginCallback {
        public boolean authenticate(String var1, String var2);
    }

    private static class CredentialsHolder {
        AuthenticationRequestListener.Credentials credentials = null;

        private CredentialsHolder() {
        }
    }
}

