/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.r;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.analyser.ProcessPool;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RAnalysisJob
extends OnDiskAnalysisJobBase {
    private static final String R_STRING_SEPARATOR = "\"";
    public static RParameterSecurityPolicy R_PARAMETER_SECURITY_POLICY = new RParameterSecurityPolicy();
    static final Logger logger = Logger.getLogger(RAnalysisJob.class);
    private static String SCRIPT_SUCCESSFUL_STRING = "script-finished-succesfully";
    private static String SCRIPT_FAILED_STRING = "script-finished-unsuccesfully";
    private int rTimeout;
    private CountDownLatch waitRLatch = new CountDownLatch(1);
    private ProcessPool processPool;
    private Process process;

    protected RAnalysisJob() {
        this.rTimeout = DirectoryLayout.getInstance().getConfiguration().getInt("comp", "r-timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws JobCancelledException {
        List<String> parameterValues;
        this.cancelCheck();
        this.updateStateDetailToClient("initialising R");
        ArrayList<BufferedReader> inputReaders = new ArrayList<BufferedReader>();
        inputReaders.add(new BufferedReader(new StringReader(this.analysis.getInitialiser())));
        logger.debug((Object)("job work dir: " + this.jobWorkDir.getPath()));
        inputReaders.add(new BufferedReader(new StringReader("setwd(\"" + this.jobWorkDir.getName() + "\")\n")));
        int i = 0;
        try {
            parameterValues = this.inputMessage.getParameters(R_PARAMETER_SECURITY_POLICY, this.analysis);
        }
        catch (JobMessage.ParameterValidityException e) {
            this.outputMessage.setErrorMessage("There was an invalid parameter value.");
            this.outputMessage.setOutputText(e.toString());
            this.updateState(JobState.FAILED_USER_ERROR, "");
            return;
        }
        for (AnalysisDescription.ParameterDescription param : this.analysis.getParameters()) {
            String value = new String(parameterValues.get(i));
            String rSnippet = RAnalysisJob.transformVariable(param.getName(), value, param.isNumeric());
            logger.debug((Object)("added parameter (" + rSnippet + ")"));
            inputReaders.add(new BufferedReader(new StringReader(rSnippet)));
            ++i;
        }
        String script = (String)this.analysis.getImplementation();
        inputReaders.add(new BufferedReader(new StringReader(script)));
        inputReaders.add(new BufferedReader(new StringReader("print(\"" + SCRIPT_SUCCESSFUL_STRING + "\")\n")));
        this.cancelCheck();
        logger.debug((Object)"getting a process.");
        try {
            this.process = this.processPool.getProcess();
        }
        catch (Exception e) {
            this.outputMessage.setErrorMessage("Starting R failed.");
            this.outputMessage.setOutputText(e.toString());
            this.updateState(JobState.ERROR, "");
            return;
        }
        boolean processAlive = false;
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            processAlive = true;
        }
        if (!processAlive) {
            this.outputMessage.setErrorMessage("Starting R failed.");
            this.outputMessage.setOutputText("R already finished.");
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.updateStateDetailToClient("running R");
        this.cancelCheck();
        logger.debug((Object)"about to start the R process monitor.");
        RProcessMonitor processMonitor = new RProcessMonitor();
        new Thread(processMonitor).start();
        logger.debug((Object)"writing the input to R.");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            for (BufferedReader reader : inputReaders) {
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
            }
            writer.flush();
            IOUtils.closeIfPossible(writer);
        }
        catch (IOException ioe) {
            logger.debug((Object)"writing input failed", (Throwable)ioe);
        }
        finally {
            IOUtils.closeIfPossible(writer);
        }
        this.cancelCheck();
        logger.debug((Object)"waiting for the script to finish.");
        try {
            this.waitRLatch.await(this.rTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.outputMessage.setErrorMessage("Running R was interrupted.");
            this.outputMessage.setOutputText(e.toString());
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.cancelCheck();
        logger.debug((Object)("done waiting for " + this.analysis.getFullName() + ", state is " + (Object)((Object)this.getState())));
        String output = processMonitor.getOutput();
        output = output.substring(output.indexOf("\n"));
        this.outputMessage.setOutputText(output);
        switch (this.getState()) {
            case RUNNING: {
                this.outputMessage.setErrorMessage("R did not finish before timeout.");
                this.updateState(JobState.TIMEOUT, "");
                return;
            }
            case COMPLETED: {
                this.updateState(JobState.RUNNING, "R script finished successfully");
                this.updateStateDetailToClient("R script finished successfully");
                return;
            }
            case FAILED: {
                if (this.outputMessage.getErrorMessage() == null || this.outputMessage.getErrorMessage().equals("")) {
                    this.outputMessage.setErrorMessage("Running R script failed.");
                }
                return;
            }
            case FAILED_USER_ERROR: {
                return;
            }
            case ERROR: {
                this.outputMessage.setErrorMessage("Reading R output failed.");
                return;
            }
        }
        throw new IllegalStateException("Illegal job state: " + (Object)((Object)this.getState()));
    }

    @Override
    protected void preExecute() throws JobCancelledException {
        super.preExecute();
    }

    @Override
    protected void postExecute() throws JobCancelledException {
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        try {
            if (this.process != null) {
                this.processPool.releaseProcess(this.process, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error when releasing process. ", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }

    public static String transformVariable(String name, String value, boolean isNumeric) {
        if (!isNumeric) {
            value = R_STRING_SEPARATOR + value + R_STRING_SEPARATOR;
        }
        name = name.replaceAll(" ", "_");
        return name + " <- " + value;
    }

    @Override
    protected void cancelRequested() {
        this.waitRLatch.countDown();
    }

    public void setProcessPool(ProcessPool processPool) {
        this.processPool = processPool;
    }

    private class RProcessMonitor
    implements Runnable {
        private final String ERROR_MESSAGE_TOKEN = "Error";
        private final String CHIPSTER_NOTE_TOKEN = "CHIPSTER-NOTE:";
        private ArrayList<String> outputLines;

        private RProcessMonitor() {
        }

        @Override
        public void run() {
            logger.debug((Object)"R process monitor started.");
            this.outputLines = new ArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader(RAnalysisJob.this.process.getInputStream()));
            boolean readMore = true;
            try {
                String line = reader.readLine();
                while (readMore) {
                    if (line == null || line.contains(SCRIPT_FAILED_STRING)) {
                        RAnalysisJob.this.updateState(JobState.FAILED, "R script failed");
                        readMore = false;
                    } else if (line.contains(SCRIPT_SUCCESSFUL_STRING)) {
                        RAnalysisJob.this.updateState(JobState.COMPLETED, "R script finished successfully");
                        readMore = false;
                    } else {
                        this.outputLines.add(line);
                    }
                    line = reader.readLine();
                }
                if (RAnalysisJob.this.getState() == JobState.FAILED) {
                    int errorLineNumber = -1;
                    for (int i = this.outputLines.size(); i > 0 && errorLineNumber == -1; --i) {
                        if (!this.outputLines.get(i - 1).startsWith("Error")) continue;
                        errorLineNumber = i - 1;
                    }
                    if (errorLineNumber != -1) {
                        String errorMessage = "";
                        errorMessage = errorMessage + this.outputLines.get(errorLineNumber).substring("Error".length()) + "\n";
                        for (int i = errorLineNumber + 1; i < this.outputLines.size() - 1; ++i) {
                            errorMessage = errorMessage + this.outputLines.get(i) + "\n";
                        }
                        errorMessage = errorMessage.substring(0, errorMessage.lastIndexOf("\n"));
                        if ((errorMessage = errorMessage.trim()).contains("CHIPSTER-NOTE:")) {
                            errorMessage = errorMessage.substring(errorMessage.indexOf("CHIPSTER-NOTE:") + "CHIPSTER-NOTE:".length());
                            errorMessage = errorMessage.trim();
                            RAnalysisJob.this.updateState(JobState.FAILED_USER_ERROR, "");
                        }
                        RAnalysisJob.this.outputMessage.setErrorMessage(errorMessage);
                    }
                }
            }
            catch (IOException e) {
                logger.debug((Object)"error in monitoring R process.");
                RAnalysisJob.this.updateState(JobState.ERROR, "reading R output failed.");
            }
            RAnalysisJob.this.waitRLatch.countDown();
        }

        public String getOutput() {
            StringBuilder output = new StringBuilder();
            for (String line : this.outputLines) {
                output.append(line + "\n");
            }
            return output.toString();
        }
    }

    public static class RParameterSecurityPolicy
    implements JobMessage.ParameterSecurityPolicy {
        private static final int MAX_VALUE_LENGTH = 1000;
        private static String NUMERIC_VALUE_PATTERN = "-?\\d*\\.?\\d*";
        private static String TEXT_VALUE_PATTERN = "[\\w+-_:;\\.()]*";

        @Override
        public boolean isValueValid(String value, AnalysisDescription.ParameterDescription parameterDescription) {
            if (value.length() > 1000) {
                return false;
            }
            if (parameterDescription.isNumeric()) {
                return value.matches(NUMERIC_VALUE_PATTERN);
            }
            return value.matches(TEXT_VALUE_PATTERN);
        }
    }
}

