/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OnDiskAnalysisJobBase
extends AnalysisJob {
    private static final Logger logger = Logger.getLogger(OnDiskAnalysisJobBase.class);
    protected File jobWorkDir;

    @Override
    public void construct(JobMessage inputMessage, AnalysisDescription analysis, ResultCallback resultHandler) {
        super.construct(inputMessage, analysis, resultHandler);
        this.jobWorkDir = new File(resultHandler.getWorkDir(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preExecute() throws JobCancelledException {
        this.cancelCheck();
        super.preExecute();
        this.updateStateDetailToClient("transferring input data");
        if (!this.jobWorkDir.mkdir()) {
            this.outputMessage.setErrorMessage("Creating working directory failed.");
            this.updateState(JobState.ERROR, "");
            return;
        }
        try {
            for (String fileName : this.inputMessage.payloadNames()) {
                File outputFile;
                this.cancelCheck();
                URL inputUrl = this.inputMessage.getPayload(fileName);
                BufferedInputStream inputStream = null;
                BufferedOutputStream fileStream = null;
                try {
                    inputStream = new BufferedInputStream(this.resultHandler.getFileBrokerClient().getFile(inputUrl));
                    outputFile = new File(this.jobWorkDir, fileName);
                    fileStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                    IOUtils.copy(inputStream, fileStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeIfPossible(inputStream);
                    IOUtils.closeIfPossible(fileStream);
                    throw throwable;
                }
                IOUtils.closeIfPossible(inputStream);
                IOUtils.closeIfPossible(fileStream);
                logger.debug((Object)("created input file: " + outputFile.getName() + " " + outputFile.length()));
            }
        }
        catch (Exception e) {
            this.outputMessage.setErrorMessage("Transferring input data to computing service failed.");
            this.outputMessage.setOutputText(e.toString());
            this.updateState(JobState.ERROR, "");
            return;
        }
    }

    @Override
    protected void postExecute() throws JobCancelledException {
        this.updateStateDetailToClient("transferring output data");
        this.cancelCheck();
        List<String> outputFileNames = this.analysis.getOutputFiles();
        for (String fileName : outputFileNames) {
            URL url;
            this.cancelCheck();
            File outputFile = new File(this.jobWorkDir, fileName);
            try {
                url = this.resultHandler.getFileBrokerClient().addFile(new FileInputStream(outputFile), null);
            }
            catch (Exception e) {
                logger.error((Object)"could not put file to file broker", (Throwable)e);
                this.outputMessage.setErrorMessage("Could not send output file.");
                this.outputMessage.setOutputText(e.toString());
                this.updateState(JobState.ERROR, "");
                return;
            }
            this.outputMessage.addPayload(fileName, url);
            logger.debug((Object)("transferred output file: " + fileName));
        }
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        try {
            if (this.resultHandler.shouldSweepWorkDir()) {
                Files.delTree(this.jobWorkDir);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when cleaning up job work dir.", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }
}

