/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;

public class JUnitXMLReporter
implements IResultListener {
    private static final Pattern ENTITY = Pattern.compile("&[a-zA-Z]+;.*");
    private static final Pattern LESS = Pattern.compile("<");
    private static final Pattern GREATER = Pattern.compile(">");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final Pattern QUOTE = Pattern.compile("\"");
    private static final Map<String, Pattern> ATTR_ESCAPES = new HashMap<String, Pattern>();
    private int m_numPassed = 0;
    private int m_numFailed = 0;
    private int m_numSkipped = 0;
    private int m_numFailedButIgnored = 0;
    private List<ITestResult> m_allTests = Collections.synchronizedList(new ArrayList());
    private List<ITestResult> m_configIssues = Collections.synchronizedList(new ArrayList());
    private Map<String, String> m_fileNameMap = new HashMap<String, String>();
    private int m_fileNameIncrementer = 0;

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numPassed;
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numFailedButIgnored;
    }

    public void onTestFailure(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numFailed;
    }

    public void onTestSkipped(ITestResult tr) {
        this.m_allTests.add(tr);
        ++this.m_numSkipped;
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
        this.generateReport(context);
        this.resetAll();
    }

    public void onConfigurationFailure(ITestResult itr) {
        this.m_configIssues.add(itr);
    }

    public void onConfigurationSkip(ITestResult itr) {
        this.m_configIssues.add(itr);
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    protected void generateReport(ITestContext context) {
        XMLStringBuffer document = new XMLStringBuffer("");
        document.setXmlDetails("1.0", "UTF-8");
        Properties attrs = new Properties();
        attrs.setProperty("name", this.encodeAttr(context.getName()));
        attrs.setProperty("tests", "" + this.m_allTests.size());
        attrs.setProperty("failures", "" + this.m_numFailed);
        attrs.setProperty("errors", "0");
        attrs.setProperty("time", "" + (double)(context.getEndDate().getTime() - context.getStartDate().getTime()) / 1000.0);
        document.push("testsuite", attrs);
        document.addEmptyElement("properties");
        for (ITestResult tr : this.m_configIssues) {
            this.createElement(document, tr);
        }
        for (ITestResult tr : this.m_allTests) {
            this.createElement(document, tr);
        }
        document.pop();
        Utils.writeUtf8File(context.getOutputDirectory(), this.generateFileName(context) + ".xml", document.toXML());
    }

    private void createElement(XMLStringBuffer doc, ITestResult tr) {
        Properties attrs = new Properties();
        long elapsedTimeMillis = tr.getEndMillis() - tr.getStartMillis();
        String name = tr.getMethod().isTest() ? tr.getName() : Utils.detailedMethodName(tr.getMethod(), false);
        attrs.setProperty("name", name);
        attrs.setProperty("classname", tr.getTestClass().getRealClass().getName());
        attrs.setProperty("time", "" + (double)elapsedTimeMillis / 1000.0);
        if (2 == tr.getStatus() || 3 == tr.getStatus()) {
            doc.push("testcase", attrs);
            if (2 == tr.getStatus()) {
                this.createFailureElement(doc, tr);
            } else if (3 == tr.getStatus()) {
                this.createSkipElement(doc, tr);
            }
            doc.pop();
        } else {
            doc.addEmptyElement("testcase", attrs);
        }
    }

    private void createFailureElement(XMLStringBuffer doc, ITestResult tr) {
        Properties attrs = new Properties();
        Throwable t = tr.getThrowable();
        if (t != null) {
            attrs.setProperty("type", t.getClass().getName());
            String message = t.getMessage();
            if (message != null && message.length() > 0) {
                attrs.setProperty("message", this.encodeAttr(message));
            }
            doc.push("failure", attrs);
            doc.addCDATA(Utils.stackTrace(t, false)[0]);
            doc.pop();
        } else {
            doc.addEmptyElement("failure");
        }
    }

    private void createSkipElement(XMLStringBuffer doc, ITestResult tr) {
        doc.addEmptyElement("skipped");
    }

    private String encodeAttr(String attr) {
        String result = this.replaceAmpersand(attr, ENTITY);
        for (Map.Entry<String, Pattern> e : ATTR_ESCAPES.entrySet()) {
            result = e.getValue().matcher(result).replaceAll(e.getKey());
        }
        return result;
    }

    private String replaceAmpersand(String str, Pattern pattern) {
        int start = 0;
        int idx = str.indexOf(38, start);
        if (idx == -1) {
            return str;
        }
        StringBuffer result = new StringBuffer();
        while (idx != -1) {
            result.append(str.substring(start, idx));
            if (pattern.matcher(str.substring(idx)).matches()) {
                result.append("&");
            } else {
                result.append("&amp;");
            }
            start = idx + 1;
            idx = str.indexOf(38, start);
        }
        result.append(str.substring(start));
        return result.toString();
    }

    private void resetAll() {
        this.m_allTests = Collections.synchronizedList(new ArrayList());
        this.m_configIssues = Collections.synchronizedList(new ArrayList());
        this.m_numFailed = 0;
        this.m_numFailedButIgnored = 0;
        this.m_numPassed = 0;
        this.m_numSkipped = 0;
    }

    private String generateFileName(ITestContext context) {
        String fileName = null;
        String keyToSearch = context.getSuite().getName() + context.getName();
        fileName = this.m_fileNameMap.get(keyToSearch) == null ? context.getName() : context.getName() + this.m_fileNameIncrementer++;
        this.m_fileNameMap.put(keyToSearch, fileName);
        return fileName;
    }

    static {
        ATTR_ESCAPES.put("&lt;", LESS);
        ATTR_ESCAPES.put("&gt;", GREATER);
        ATTR_ESCAPES.put("&apos;", SINGLE_QUOTE);
        ATTR_ESCAPES.put("&quot;", QUOTE);
    }
}

