/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    public static String delimit(Iterable<String> strings, String delimeter) {
        String result = "";
        boolean first = true;
        for (String string : strings) {
            if (first) {
                result = string;
                first = false;
                continue;
            }
            result = result + delimeter + string;
        }
        return result;
    }

    public static String repeat(String string, int times) {
        String result = "";
        for (int c = 0; c < times; ++c) {
            result = result + string;
        }
        return result;
    }

    public static String[] repeatToArray(String string, int times) {
        String[] result = new String[times];
        for (int c = 0; c < times; ++c) {
            result[c] = string;
        }
        return result;
    }

    public static String indent(String string, int spaces) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        String result = "";
        while (st.hasMoreTokens()) {
            result = result + Strings.repeat(" ", spaces) + st.nextToken() + "\n";
        }
        return result;
    }

    public static String crop(String string, int length) {
        return string.length() > length ? string.substring(0, length) : string;
    }

    public static boolean isFloatNumber(String string) {
        Float v = null;
        try {
            v = Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v != null;
    }

    public static boolean isAnyOf(String toCompare, boolean caseSensitive, String ... strings) {
        if (!caseSensitive) {
            toCompare = toCompare.toLowerCase();
        }
        for (String string : strings) {
            if (!caseSensitive) {
                string = string.toLowerCase();
            }
            if (!toCompare.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String toString(int value, int digitCount) {
        String digits;
        String prefix = "";
        if (value < 0) {
            prefix = prefix + "-";
            digits = "" + -value;
        } else {
            digits = "" + value;
        }
        while (digits.length() < digitCount) {
            digits = "0" + digits;
        }
        return prefix + digits;
    }

    public static String startWithUppercase(String string) {
        if (string.length() > 0) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String separateUppercaseChars(String string, String separator) {
        String result = "";
        char prev = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            if (Character.isUpperCase(current) && Character.isUpperCase(prev)) {
                result = result + separator;
            }
            result = result + current;
            prev = string.charAt(i);
        }
        return result;
    }
}

