/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.stat;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.biobeans.BioBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProviderBase;
import fi.csc.microarray.databeans.features.NonexistingFeature;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class HierarchicalClusterProvider
extends FeatureProviderBase {
    public Feature createFeature(String namePostfix, final DataBean bean) {
        if ("heatmap".equals(namePostfix)) {
            DataBean source = new BioBean(bean).getProperSource();
            if (source != null) {
                return source.queryFeatures("/column/*").asFeature();
            }
            return new NonexistingFeature(bean, this);
        }
        if ("tree".equals(namePostfix)) {
            return new BasicFeature(bean, this){

                @Override
                public Iterable<String> asStrings() throws MicroarrayException {
                    BufferedReader reader = null;
                    String tree = "";
                    try {
                        reader = new BufferedReader(new InputStreamReader(bean.getContentByteStream()));
                        boolean first = true;
                        String line = reader.readLine();
                        while (line != null) {
                            tree = tree + line;
                            if (first && !line.contains(":") && !line.contains("(")) {
                                Iterable<String> iterable = null;
                                return iterable;
                            }
                            first = false;
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new MicroarrayException(e);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                    return Arrays.asList(tree);
                }
            };
        }
        throw new IllegalArgumentException("unknown postfix: " + namePostfix);
    }
}

