/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.ModifiedFeature;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictModifier
implements Modifier {
    public static final int RESTRICT_TO_ROWS = 2000;
    private RestrictModifierFeature output;

    @Override
    public Feature getOutput() {
        return this.output;
    }

    @Override
    public void setInputs(List<Feature> inputs) {
        this.output = new RestrictModifierFeature(inputs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RestrictModifierFeature
    extends ModifiedFeature {
        private Feature original;

        protected RestrictModifierFeature(List<Feature> inputs) {
            super(inputs);
            if (inputs.size() != 1) {
                throw new IllegalArgumentException("restrict modifier must have 1 parameter");
            }
            this.original = inputs.get(0);
        }

        @Override
        public Table asTable() throws MicroarrayException {
            Table table = this.original.asTable();
            if (table == null) {
                return null;
            }
            return new RestrictedTable(table);
        }
    }

    private static class RestrictedTable
    implements Table {
        private Table table;
        private int row = 0;

        public RestrictedTable(Table table) {
            this.table = table;
        }

        public String[] getColumnNames() {
            return this.table.getColumnNames();
        }

        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        public float getFloatValue(String columnName) {
            return this.table.getFloatValue(columnName);
        }

        public int getIntValue(String columnName) {
            return this.table.getIntValue(columnName);
        }

        public String getStringValue(String columnName) {
            return this.table.getStringValue(columnName);
        }

        public Object getValue(String columnName) {
            return this.table.getValue(columnName);
        }

        public boolean hasColumn(String columnName) {
            return this.table.hasColumn(columnName);
        }

        public boolean nextRow() {
            ++this.row;
            return this.row < 2000 && this.table.nextRow();
        }

        public void close() {
            this.table.close();
        }
    }
}

