/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import fi.csc.microarray.client.visualisation.methods.threed.RoundGradientPaint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPoint
extends Drawable {
    private double radius;
    private double effectiveRadius;
    private int index;
    private static final int SELECTION_DISTANCE = 4;

    public DataPoint(double xData, double yData, double zData, Color color, double radius, String text, int index) {
        this.radius = this.effectiveRadius = radius;
        this.visualisationCoords = new double[1][3];
        this.projectedCoords = new double[1][2];
        this.deviceCoords = new int[1][2];
        this.dataCoords = new double[1][3];
        this.distanceFromCamera = new double[1];
        this.index = index;
        double d = xData;
        this.visualisationCoords[0][0] = d;
        this.dataCoords[0][0] = d;
        double d2 = yData;
        this.visualisationCoords[0][1] = d2;
        this.dataCoords[0][1] = d2;
        double d3 = zData;
        this.visualisationCoords[0][2] = d3;
        this.dataCoords[0][2] = d3;
        this.color = color;
        this.text = text;
    }

    public int getIndex() {
        return this.index;
    }

    public DataPoint(double xData, double yData, double zData, Color color, double radius, CoordinateArea coordianteArea, String geneId) {
        this(xData, yData, zData, color, radius, null, -1);
    }

    @Override
    public void draw(Graphics g, int width, int height, CoordinateArea.PaintMode paintMode) {
        Graphics2D g2d = (Graphics2D)g;
        if (Math.abs(this.projectedCoords[0][0]) > 0.5 || Math.abs(this.projectedCoords[0][1]) > 0.5 || this.hidden) {
            return;
        }
        g2d.setColor(this.color);
        this.deviceCoords[0][0] = (int)((this.projectedCoords[0][0] + 0.5) * (double)width);
        this.deviceCoords[0][1] = (int)((this.projectedCoords[0][1] + 0.5) * (double)height);
        double screenRadius = 0.5;
        if (this.effectiveRadius * (double)width > 0.5) {
            screenRadius = this.effectiveRadius * (double)width;
        }
        int x = this.deviceCoords[0][0] - (int)screenRadius;
        int y = this.deviceCoords[0][1] - (int)screenRadius;
        int w = (int)(screenRadius * 2.0);
        int h = (int)(screenRadius * 2.0);
        if (paintMode == CoordinateArea.PaintMode.PIXEL) {
            g2d.setPaint(this.color);
            g2d.drawLine(x + w / 2, y + h / 2, x + w / 2, y + h / 2);
        } else {
            DataPoint.paintBall(x, y, w, h, this.color, g2d);
        }
        if (this.selected) {
            g2d.setPaint(Color.WHITE);
            g2d.drawOval(x - 2, y - 2, w + 4, h + 4);
        }
    }

    public static void paintBall(int x, int y, int w, int h, Color c, Graphics2D g2d) {
        int radius = (int)((double)w * 0.75);
        radius = radius > 0 ? radius : 1;
        g2d.setPaint(new RoundGradientPaint((double)x + (double)w / 4.0, (double)y + (double)h / 4.0, c, new Point(radius, radius), Color.BLACK));
        g2d.fillOval(x, y, w, h);
    }

    @Override
    public void setDistanceFromCamera(double[] camera, double planeDistance, double viewWindowWidth, double viewWindowHeight) {
        this.distanceFromCamera[0] = DataPoint.pointDistance(camera, this.visualisationCoords[0]);
        double distanceScalar = planeDistance / this.distanceFromCamera[0];
        this.effectiveRadius = this.radius / viewWindowWidth * distanceScalar;
    }

    public static final LinkedList<DataPoint> getNearest(int x, int y, Drawable[] points, double maxDist) {
        LinkedList<DataPoint> list = new LinkedList<DataPoint>();
        DataPoint dp = null;
        double dist = Double.MAX_VALUE;
        for (Drawable d : points) {
            int yDiff;
            int xDiff;
            double tmp;
            if (!(d instanceof DataPoint) || !((tmp = Math.sqrt((xDiff = x - d.deviceCoords[0][0]) * xDiff + (yDiff = y - d.deviceCoords[0][1]) * yDiff)) < dist) || !(tmp <= maxDist)) continue;
            dist = tmp;
            dp = (DataPoint)d;
        }
        if (dp != null) {
            list.add(dp);
        }
        return list;
    }

    public static final LinkedList<DataPoint> getNearest(int x, int y, Drawable[] points) {
        return DataPoint.getNearest(x, y, points, 4.0);
    }

    public static final LinkedList<DataPoint> getGroup(int x1, int y1, int x2, int y2, Drawable[] points) {
        int tmp;
        LinkedList<DataPoint> list = new LinkedList<DataPoint>();
        if (x1 > x2) {
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if (y1 > y2) {
            tmp = y2;
            y2 = y1;
            y1 = tmp;
        }
        for (Drawable d : points) {
            if (!(d instanceof DataPoint) || d.deviceCoords[0][0] < x1 || d.deviceCoords[0][0] > x2 || d.deviceCoords[0][1] < y1 || d.deviceCoords[0][1] > y2) continue;
            list.add((DataPoint)d);
        }
        return list;
    }

    public static final double pointDistance(double[] a, double[] b) {
        double xD = a[0] - b[0];
        double yD = a[1] - b[1];
        double zD = a[2] - b[2];
        return Math.sqrt(xD * xD + yD * yD + zD * zD);
    }

    public String toString() {
        return this.text;
    }
}

