/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulerTrack
extends Track {
    private static final int textY = 10;
    private static final int MINOR_STEPS = 5;
    List<Long> info = new ArrayList<Long>();

    public RulerTrack(View view) {
        super(view, null);
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Region region = this.getView().getBpRegion();
        long magnitude = (long)Math.pow(10.0, (int)Math.log10(region.getLength()));
        long start = region.start - region.start % magnitude;
        int steps = (int)Math.ceil(region.getLength() / magnitude) + 1;
        long end = start + (long)steps * magnitude;
        for (long bp = start; bp <= end; bp += magnitude) {
            int x = this.getView().bpToTrack(bp);
            String text = Utils.toHumanReadable(bp);
            drawables.add(new TextDrawable(x, 10, text, Color.black));
        }
        drawables.addAll(this.getRuler(start, end, steps * 5, start / magnitude % 2L == 1L));
        return drawables;
    }

    private Collection<Drawable> getRuler(long startBp, long endBp, int steps, boolean whiteStart) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        boolean isWhite = whiteStart;
        int boxHeight = 5;
        double increment = (double)(endBp - startBp) / (double)steps;
        double boxBp = startBp;
        int lastBoxX = this.getView().bpToTrack(startBp);
        this.info.clear();
        for (int i = 0; i < steps; ++i) {
            isWhite = !isWhite;
            Color c = isWhite ? Color.white : Color.black;
            this.info.add((long)(boxBp += increment));
            int boxX = this.getView().bpToTrack((long)boxBp);
            drawables.add(new RectDrawable(lastBoxX, 10, boxX - lastBoxX, 5, c, Color.black));
            Color lineColor = i % 5 == 4 ? new Color(0, 0, 0, 64) : new Color(0, 0, 0, 32);
            drawables.add(new LineDrawable(boxX, -this.getView().getHeight() + this.getMaxHeight(), boxX, this.getMaxHeight(), lineColor));
            lastBoxX = boxX;
        }
        return drawables;
    }

    public void processAreaResult(AreaResult areaResult) {
    }

    public List<Long> getRulerInfo() {
        return this.info;
    }

    @Override
    public int getMaxHeight() {
        return 20;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(new Content[0]);
    }

    @Override
    public boolean isConcised() {
        return false;
    }
}

