/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.StraightforwardFileParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueManager
implements AreaResultListener {
    Map<File, QueueContext> queues = new HashMap<File, QueueContext>();

    public void createQueue(File file, ReadInstructions<?> readInstructions) {
        this.createQueue(file, StraightforwardFileParser.class, readInstructions);
    }

    public void createQueue(File file, Class<? extends AreaRequestHandler> dataFetcher, ReadInstructions<?> readInstructions) {
        if (!this.queues.containsKey(file)) {
            QueueContext context = new QueueContext();
            context.queue = new ConcurrentLinkedQueue<AreaRequest>();
            try {
                context.thread = dataFetcher.getConstructor(File.class, Queue.class, AreaResultListener.class, ReadInstructions.class).newInstance(file, context.queue, this, readInstructions);
                this.queues.put(file, context);
                context.thread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addAreaRequest(File file, AreaRequest req, boolean clearQueues) {
        req.status.file = file;
        QueueContext context = this.queues.get(file);
        req.status.maybeClearQueue(context.queue);
        context.queue.add(req);
        context.thread.notifyTree();
    }

    public void addResultListener(File file, AreaResultListener listener) {
        this.queues.get((Object)file).listeners.add(listener);
    }

    public void processAreaResult(AreaResult areaResult) {
        for (AreaResultListener listener : this.queues.get((Object)areaResult.status.file).listeners) {
            listener.processAreaResult(areaResult);
        }
    }

    private class QueueContext {
        public Queue<AreaRequest> queue;
        public Collection<AreaResultListener> listeners = new ArrayList<AreaResultListener>();
        public AreaRequestHandler thread;

        private QueueContext() {
        }
    }
}

