/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.visualisation.MicroarrayTable;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.DefaultTableModel;

public class Spreadsheet
extends Visualisation {
    private final int COLUMNS_REQUIRES_SCROLLING = 8;
    private MicroarrayTable table;

    public Spreadsheet(VisualisationFrame frame) {
        super(frame);
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        JPanel panel = new JPanel(new BorderLayout());
        Table rowCounter = data.queryFeatures("/column/*").asTable();
        int rowCount = 0;
        while (rowCounter.nextRow()) {
            ++rowCount;
        }
        Table columns = data.queryFeatures("restrict(/column/*)").asTable();
        Object[] columnTitles = new String[columns.getColumnCount()];
        int counter = 0;
        String[] arr$ = columns.getColumnNames();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String column;
            columnTitles[counter] = column = arr$[i$];
            ++counter;
        }
        Object[][] rowData = new Object[2000 < rowCount ? 2000 : rowCount][columns.getColumnCount()];
        int row = 0;
        while (columns.nextRow()) {
            int column = 0;
            for (String columnName : columns.getColumnNames()) {
                Object value = columns.getValue(columnName);
                if (value instanceof Float) {
                    value = new NicelyShowingFloat((Float)value);
                }
                rowData[row][column] = value;
                ++column;
            }
            ++row;
        }
        this.table = new MicroarrayTable(data);
        DefaultTableModel tableModel = new DefaultTableModel(rowData, columnTitles){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(tableModel);
        this.table.setColumnControlVisible(true);
        JScrollPane tableScroller = new JScrollPane((Component)((Object)this.table));
        this.table.setBackground(Color.white);
        this.table.setHorizontalScrollEnabled(columns.getColumnCount() > 8);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SpreadsheetPopupMenu popup = new SpreadsheetPopupMenu(Spreadsheet.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        panel.add((Component)new JLabel("Showing " + rowData.length + " rows of " + rowCount), "North");
        panel.add((Component)tableScroller, "Center");
        this.table.updateSelectionsFromApplication();
        this.table.sendEvents(true);
        return panel;
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        if (bean.isContentTypeCompatitible("text/tab", "text/csv")) {
            return true;
        }
        if (bean.isContentTypeCompatitible("application/cel")) {
            return !bean.queryFeatures("/embedded-binary-content/").exists();
        }
        return false;
    }

    public void removeVisualisation() {
        this.application.removePropertyChangeListener(this.table);
    }

    public static class NicelyShowingFloat
    implements Comparable {
        private Float floatValue;

        public NicelyShowingFloat(Float floatValue) {
            this.floatValue = floatValue;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NicelyShowingFloat) {
                return this.floatValue.equals(((NicelyShowingFloat)obj).floatValue);
            }
            throw new IllegalArgumentException("cannot compare to instance of " + obj.getClass().getSimpleName());
        }

        public int hashCode() {
            return this.floatValue.hashCode();
        }

        public String toString() {
            String s = this.floatValue.toString();
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
            return s;
        }

        public int compareTo(Object obj) {
            if (obj instanceof NicelyShowingFloat) {
                return this.floatValue.compareTo(((NicelyShowingFloat)obj).floatValue);
            }
            throw new IllegalArgumentException("cannot compare to instance of " + obj.getClass().getSimpleName());
        }
    }

    public class SpreadsheetPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private MicroarrayTable table;
        private JMenuItem annotateMenuItem;
        private JMenuItem copyMenuItem;
        private JMenuItem filterMenuItem;

        public SpreadsheetPopupMenu(MicroarrayTable table) {
            this.table = table;
            this.copyMenuItem = new JMenuItem("Copy");
            this.annotateMenuItem = new JMenuItem("Create dataset and annotate with Bioconductor");
            this.filterMenuItem = new JMenuItem("Create dataset");
            this.copyMenuItem.addActionListener(this);
            this.annotateMenuItem.addActionListener(this);
            this.filterMenuItem.addActionListener(this);
            this.add(this.copyMenuItem);
            this.add(new JSeparator());
            this.add(this.annotateMenuItem);
            this.add(this.filterMenuItem);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.annotateMenuItem) {
                VisualisationUtilities.annotateBySelection(Spreadsheet.this.getFrame().getDatas());
            }
            if (e.getSource() == this.copyMenuItem) {
                this.table.copy();
            }
            if (e.getSource() == this.filterMenuItem) {
                VisualisationUtilities.filterBySelection(Spreadsheet.this.getFrame().getDatas());
            }
        }
    }
}

