/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.SOMPlot;
import org.jfree.data.som.SOMDataItem;
import org.jfree.data.som.SOMDataset;

public class SOM
extends Visualisation {
    public SOM(VisualisationFrame frame) {
        super(frame);
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        Table som = data.queryFeatures("/clusters/som").asTable();
        int maxX = 0;
        int maxY = 0;
        while (som.nextRow()) {
            if (som.getIntValue("x") > maxX) {
                maxX = som.getIntValue("x");
            }
            if (som.getIntValue("y") <= maxY) continue;
            maxY = som.getIntValue("y");
        }
        SOMDataset dataset = new SOMDataset(maxX, maxY);
        som = data.queryFeatures("/clusters/som").asTable();
        TableAnnotationProvider annotationProvider = new TableAnnotationProvider(data);
        while (som.nextRow()) {
            String colorStr = som.getStringValue("color");
            if (colorStr.charAt(0) != '#') {
                throw new RuntimeException("color format not supported for SOM visualization: " + colorStr);
            }
            Color color = Color.decode(colorStr.substring(0));
            ArrayList<String> values = new ArrayList<String>();
            for (String idList : som.getStringValue("values").split(", ")) {
                for (String id : idList.trim().split(" ")) {
                    values.add(annotationProvider.getAnnotatedRowname(id.trim()));
                }
            }
            String[] vectorStrings = som.getStringValue("vector").split(",");
            double[] vectorDoubles = new double[vectorStrings.length];
            for (int i = 0; i < vectorStrings.length; ++i) {
                vectorDoubles[i] = Double.parseDouble(vectorStrings[i]);
            }
            SOMDataItem dataItem = new SOMDataItem(color, values.toArray(new String[values.size()]), vectorDoubles);
            int x = som.getIntValue("x");
            int y = som.getIntValue("y");
            dataset.addValue(x - 1, y - 1, dataItem);
        }
        JFreeChart chart = BioChartFactory.createSOMChart((String)(data.getName() + " SOM Chart"), (SOMDataset)dataset, (boolean)true, (boolean)false);
        ChartPanel chartPanel = SOM.makePanel(chart);
        chartPanel.addChartMouseListener((ChartMouseListener)((SOMPlot)chart.getPlot()));
        chartPanel.setFocusable(true);
        return chartPanel;
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        return isTabular && bean.queryFeatures("/clusters/som").exists();
    }
}

