/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.BrowsableHtmlPanel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class HtmlViewer
extends Visualisation {
    public HtmlViewer(VisualisationFrame frame) {
        super(frame);
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        byte[] html = data.getContents();
        if (html != null) {
            JTextPane htmlPane = BrowsableHtmlPanel.createHtmlPanel();
            String htmlStr = new String(html);
            htmlStr = htmlStr.replace("<head>", "<head><style type=\"text/css\"><!--table {border-color: Gray; border-width: 1px; border-style: solid;}td { border-color: Gray; font-family: sans-serif; border-width: 1px; border-style: solid; font-size: 8px}th { border-color: Gray; font-family: sans-serif; background: #E0E0E0; text-align: center;  border-width: 1px; border-style: solid;}--></style>");
            htmlStr = htmlStr.replace(" border=\"2\"", "");
            htmlPane.setText(htmlStr);
            return new JScrollPane(htmlPane);
        }
        return this.getDefaultVisualisation();
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean.isContentTypeCompatitible("text/html");
    }
}

