/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.SelectableChartPanel;
import fi.csc.microarray.client.visualisation.methods.hc.OrderSuperviser;
import fi.csc.microarray.cluster.ClusterBranchNode;
import fi.csc.microarray.cluster.ClusterLeafNode;
import fi.csc.microarray.cluster.ClusterNode;
import fi.csc.microarray.cluster.ClusterParser;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.ErrorReportAsException;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.entity.HeatMapBlockEntity;
import org.jfree.chart.event.ClusteringTreeChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.labels.HCToolTipGenerator;
import org.jfree.chart.labels.StandardHCToolTipGenerator;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.DataRangeMismatchException;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HeatMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalClustering
extends Visualisation
implements PropertyChangeListener,
SelectableChartPanel.SelectionChangeListener {
    private SelectableChartPanel selectableChartPanel;
    private static final Logger logger = Logger.getLogger(HierarchicalClustering.class);
    OrderSuperviser orders;
    private JPanel paramPanel;
    private AnnotateListPanel list;
    private Set<Integer> selected = new HashSet<Integer>();
    private DataBean selectionBean;
    private HCPlot hcPlot;
    private boolean reversed;
    private JPanel zoomChangerPanel;
    private JPanel spaceFiller;
    private JScrollPane scroller;
    private Dimension preferredSize;
    private JCheckBox zoomCheckBox;

    public HierarchicalClustering(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            JPanel settings = this.createSettingsPanel();
            this.list = new AnnotateListPanel();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settings);
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    public JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.zoomCheckBox = new JCheckBox("Fit to screen", false);
        this.zoomCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HierarchicalClustering.this.setScaledMode(HierarchicalClustering.this.zoomCheckBox.isSelected());
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 0, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        settingsPanel.add((Component)this.zoomCheckBox, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        settingsPanel.add((Component)new JPanel(), c);
        return settingsPanel;
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws MicroarrayException {
        List<DataBean> selectionBeans = data.traverseLinks(new DataBean.Link[]{DataBean.Link.DERIVATION}, DataBean.Traversal.DIRECT);
        if (selectionBeans.size() > 1) {
            this.selectionBean = selectionBeans.get(1);
        }
        if (this.selectionBean == null) {
            throw new ErrorReportAsException("Source dataset not found", "Hierarchical clustering needs its source dataset.", " Select both HC and its source dataset by keeping \nCtrl key pressed and right click with mouse over one of them to create \nderivation link from the original dataset to \nclustered one.");
        }
        try {
            String hcTree = data.queryFeatures("/clusters/hierarchical/tree").asStrings().iterator().next();
            QueryResult heatMapFeature = data.queryFeatures("/clusters/hierarchical/heatmap");
            Table heatMapData = heatMapFeature.asTable();
            TableAnnotationProvider annotationProvider = new TableAnnotationProvider(this.selectionBean);
            int rowCount = 0;
            while (heatMapData.nextRow()) {
                ++rowCount;
            }
            LinkedList<String> columns = new LinkedList<String>();
            for (String columnName : heatMapData.getColumnNames()) {
                if (columnName.startsWith("chip.")) {
                    columns.add(columnName);
                    continue;
                }
                logger.debug((Object)("Column skipped in HC: " + columnName));
            }
            int columnCount = columns.size();
            HCTreeNode root = null;
            ClusterParser parser = new ClusterParser(hcTree);
            ClusterBranchNode tree = parser.getTree();
            this.reversed = hcTree.contains("chip.");
            HeatMap heatMap = null;
            if (!this.reversed) {
                rowCount = tree.getLeafCount();
                heatMap = new HeatMap("Heatmap", rowCount, columnCount);
            } else {
                heatMap = new HeatMap("Heatmap", columnCount, rowCount);
            }
            int initialHeight = this.getTreeHeight(tree);
            ArrayList<String> treeToId = new ArrayList<String>();
            treeToId.addAll(Collections.nCopies(rowCount, null));
            root = this.readTree(tree, 0, initialHeight, treeToId);
            this.orders = new OrderSuperviser();
            this.orders.setTreeToId(treeToId);
            heatMapData = data.queryFeatures("/clusters/hierarchical/heatmap").asTable();
            ArrayList<Integer> treeToBean = new ArrayList<Integer>();
            treeToBean.addAll(Collections.nCopies(rowCount, -1));
            int row = -1;
            int originalRow = 0;
            while (heatMapData.nextRow()) {
                if (!this.reversed) {
                    String key = this.translate(heatMapData.getStringValue(" "));
                    if (this.orders.idToTree(key) == -1) continue;
                    row = this.orders.idToTree(key);
                    treeToBean.set(row, originalRow);
                    ++originalRow;
                    logger.debug((Object)("Adding a new row to heatmap, name: " + heatMapData.getStringValue(" ") + "\tto row: " + row));
                } else {
                    ++row;
                }
                String geneName = heatMapData.getStringValue(" ");
                geneName = annotationProvider.getAnnotatedRowname(geneName);
                if (!this.reversed) {
                    heatMap.setRowName(row, geneName);
                } else {
                    heatMap.setColumnName(row, geneName);
                }
                int i = -1;
                for (String columnName : columns) {
                    if (!this.reversed) {
                        ++i;
                    } else {
                        i = this.orders.idToTree(columnName);
                        logger.debug((Object)("Adding a new row to heatmap (reversed), name: " + columnName + "\tto row: " + i));
                    }
                    if (!this.reversed) {
                        heatMap.update(row, i, (double)heatMapData.getFloatValue(columnName));
                        continue;
                    }
                    heatMap.update(i, row, (double)heatMapData.getFloatValue(columnName));
                }
            }
            this.orders.setTreeToBean(treeToBean);
            int i = -1;
            for (String columnName : columns) {
                String sampleName = columnName.substring("chip.".length());
                String realName = data.queryFeatures("/phenodata/linked/describe/" + sampleName).asString();
                if (!this.reversed) {
                    ++i;
                } else {
                    i = this.orders.idToTree(columnName);
                    logger.debug((Object)("Adding a new row to heatmap (reversed), name: " + columnName + "\tto row: " + i));
                }
                if (!this.reversed) {
                    heatMap.setColumnName(i, realName);
                    continue;
                }
                heatMap.setRowName(i, realName);
            }
            HCDataset dataset = new HCDataset(heatMap, root, null);
            boolean tooltips = true;
            JFreeChart chart = BioChartFactory.createHCChart((String)"Hierarchical Clustering", (HCDataset)dataset, (boolean)tooltips, (boolean)false);
            if (chart.getPlot() instanceof HCPlot) {
                HCPlot hcPlot;
                this.hcPlot = hcPlot = (HCPlot)chart.getPlot();
                this.orders.setPlot(hcPlot);
                this.hcPlot.addChangeListener(new PlotChangeListener(){

                    public void plotChanged(PlotChangeEvent event) {
                        if (event instanceof ClusteringTreeChangeEvent) {
                            HierarchicalClustering.this.orders.updateVisibleIndexes();
                            HierarchicalClustering.this.updateSelectionsFromApplication(false);
                        }
                    }
                });
                if (tooltips) {
                    hcPlot.setToolTipGenerator((HCToolTipGenerator)new MicroarrayHCToolTipGenerator());
                }
                double min = HierarchicalClustering.getMinValue(dataset.getHeatMap());
                double max = HierarchicalClustering.getMaxValue(dataset.getHeatMap());
                GradientColorPalette colors = new GradientColorPalette(new double[]{min, max}, new Color[]{Color.BLUE, Color.BLACK, Color.RED});
                hcPlot.setColoring(colors);
            }
            chart.setTitle((TextTitle)null);
            this.selectableChartPanel = new SelectableChartPanel(chart, this, false);
            this.selectableChartPanel.getChartPanel().addChartMouseListener((ChartMouseListener)((HCPlot)chart.getPlot()));
            this.updateSelectionsFromApplication(false);
            this.application.addPropertyChangeListener(this);
            int blockSize = 10;
            int width = (int)((double)(heatMap.getColumnsCount() * blockSize) + this.hcPlot.getRowTreeSize() + this.hcPlot.getRowNamesSize() + this.hcPlot.getLeftMarginSize() + this.hcPlot.getRightMarginSize());
            int height = (int)((double)(heatMap.getRowCount() * blockSize) + this.hcPlot.getColumnNamesSize() + this.hcPlot.getTopMarginSize() + this.hcPlot.getBottomMarginSize());
            this.preferredSize = new Dimension(width, height);
            this.zoomChangerPanel = new JPanel(new BorderLayout());
            this.spaceFiller = new JPanel();
            ((FlowLayout)this.spaceFiller.getLayout()).setAlignment(0);
            this.spaceFiller.setBackground(Color.white);
            this.scroller = new JScrollPane(this.spaceFiller);
            this.setScaledMode(false);
            return this.zoomChangerPanel;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ErrorReportAsException("Hierarchical clustering cannot be shown.", "The problem is probably caused by unsupported data, such as gene names that have illegal characters in them.", e);
        }
    }

    public void setScaledMode(boolean scaled) {
        if (scaled) {
            this.spaceFiller.remove(this.selectableChartPanel);
            this.zoomChangerPanel.remove(this.scroller);
            this.zoomChangerPanel.add((Component)this.selectableChartPanel, "Center");
            this.selectableChartPanel.setPreferredSize(null);
        } else {
            this.spaceFiller.add(this.selectableChartPanel);
            this.zoomChangerPanel.remove(this.selectableChartPanel);
            this.zoomChangerPanel.add((Component)this.scroller, "Center");
            this.selectableChartPanel.setPreferredSize(this.preferredSize);
        }
        this.zoomChangerPanel.validate();
        this.zoomChangerPanel.repaint();
    }

    private String translate(String gene) {
        while (gene.startsWith(" ") || gene.startsWith("(")) {
            gene = gene.substring(1);
        }
        while (gene.endsWith(" ") || gene.endsWith(")")) {
            gene = gene.substring(0, gene.length() - 1);
        }
        gene = gene.replace("(", "-").replace(")", "-").replace(" ", "_");
        while (gene.contains("--")) {
            gene = gene.replace("--", "-");
        }
        return gene;
    }

    private int getTreeHeight(ClusterNode tree) {
        int right;
        if (tree instanceof ClusterLeafNode) {
            return 0;
        }
        int left = this.getTreeHeight(((ClusterBranchNode)tree).getLeftBranch()) + 1;
        return left > (right = this.getTreeHeight(((ClusterBranchNode)tree).getRightBranch()) + 1) ? left : right;
    }

    private HCTreeNode readTree(ClusterNode tree, int index, int height, List<String> treeToId) throws DataRangeMismatchException {
        if (tree instanceof ClusterLeafNode) {
            String gene = ((ClusterLeafNode)tree).getGene();
            treeToId.set(index, gene);
            logger.debug((Object)("LeafNode: " + ((ClusterLeafNode)tree).getGene() + "in index: " + index));
            return new HCTreeNode(0.0, index);
        }
        HCTreeNode node = new HCTreeNode((double)height);
        HCTreeNode leftChild = this.readTree(((ClusterBranchNode)tree).getLeftBranch(), index, height - 1, treeToId);
        node.setLeftChild(leftChild);
        HCTreeNode rightChild = this.readTree(((ClusterBranchNode)tree).getRightBranch(), node.getDataRange().getRightBound() + 1, height - 1, treeToId);
        node.setRightChild(rightChild);
        return node;
    }

    private static Double getMinValue(HeatMap heatmap) {
        Double min = null;
        for (int row = 0; row < heatmap.getRowCount(); ++row) {
            for (int column = 0; column < heatmap.getColumnsCount(); ++column) {
                Double value = heatmap.get(row, column);
                if (min != null && !(value < min)) continue;
                min = value;
            }
        }
        return min;
    }

    private static Double getMaxValue(HeatMap heatmap) {
        Double max = null;
        for (int row = 0; row < heatmap.getRowCount(); ++row) {
            for (int column = 0; column < heatmap.getColumnsCount(); ++column) {
                Double value = heatmap.get(row, column);
                if (max != null && !(value > max)) continue;
                max = value;
            }
        }
        return max;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean.isContentTypeCompatitible("application/x-treeview") && bean.queryFeatures("/clusters/hierarchical/tree").exists() && bean.queryFeatures("/clusters/hierarchical/heatmap").exists();
    }

    @Override
    public void selectionChanged(Rectangle2D.Double selectionRect) {
        if (selectionRect == null) {
            this.selected.clear();
        } else {
            this.orders.updateVisibleIndexes();
            ChartRenderingInfo info = this.selectableChartPanel.getChartPanel().getChartRenderingInfo();
            EntityCollection entities = info.getEntityCollection();
            HashSet<Integer> newSelection = new HashSet<Integer>();
            for (Object obj : entities.getEntities()) {
                HCTreeNodeEntity entity;
                if (obj instanceof HCTreeNodeEntity && (entity = (HCTreeNodeEntity)obj).getArea().intersects(selectionRect)) {
                    return;
                }
                if (!(obj instanceof HeatMapBlockEntity) || !(entity = (HeatMapBlockEntity)obj).getArea().intersects(selectionRect)) continue;
                if (!this.reversed) {
                    newSelection.addAll(this.orders.visibleToBean(entity.getRow()));
                    continue;
                }
                newSelection.add(entity.getColumn());
            }
            for (Integer row : newSelection) {
                if (this.selected.contains(row)) {
                    this.selected.remove(row);
                    continue;
                }
                this.selected.add(row);
            }
            this.showSelection(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof RowChoiceEvent && evt.getSource() != this && ((RowChoiceEvent)evt).getData() == this.selectionBean) {
            this.updateSelectionsFromApplication(false);
        }
    }

    protected void updateSelectionsFromApplication(boolean dispatchEvent) {
        RowSelectionManager manager = this.application.getSelectionManager().getRowSelectionManager(this.selectionBean);
        this.orders.updateVisibleIndexes();
        this.selected.clear();
        for (int i : manager.getSelectedRows()) {
            this.selected.add(i);
        }
        this.showSelection(dispatchEvent);
    }

    private void showSelection(boolean dispatchEvent) {
        HCPlot.Selection[] detailedSelection = !this.reversed ? this.calculateRowSelectionDetails() : this.calculateColumnSelectionDetails();
        this.hcPlot.showSelection(detailedSelection, !this.reversed);
        this.list.setSelectedRows(this.selected, this, dispatchEvent, this.selectionBean);
    }

    private HCPlot.Selection[] calculateRowSelectionDetails() {
        int[] closedRows = this.orders.getCountOfVisibleReferences();
        int[] selectedRows = new int[closedRows.length];
        HCPlot.Selection[] detailedSelection = new HCPlot.Selection[closedRows.length];
        for (int selectedRow : this.selected) {
            int n = this.orders.beanToVisible(selectedRow);
            selectedRows[n] = selectedRows[n] + 1;
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            if (selectedRows[i] == 0) {
                detailedSelection[i] = HCPlot.Selection.NO;
                continue;
            }
            if (selectedRows[i] == closedRows[i]) {
                detailedSelection[i] = HCPlot.Selection.YES;
                continue;
            }
            if (selectedRows[i] >= closedRows[i]) continue;
            detailedSelection[i] = HCPlot.Selection.PARTIAL;
        }
        return detailedSelection;
    }

    private HCPlot.Selection[] calculateColumnSelectionDetails() {
        HCPlot.Selection[] detailedSelection = new HCPlot.Selection[this.hcPlot.getDataset().getHeatMap().getColumnsCount()];
        for (int i = 0; i < detailedSelection.length; ++i) {
            detailedSelection[i] = this.selected.contains(i) ? HCPlot.Selection.YES : HCPlot.Selection.NO;
        }
        return detailedSelection;
    }

    private class MicroarrayHCToolTipGenerator
    extends StandardHCToolTipGenerator {
        private MicroarrayHCToolTipGenerator() {
        }

        public String generateToolTip(HeatMap heatmap, DataRange rowRange, DataRange columnRange) {
            int maxColumn;
            int minColumn;
            int maxRow;
            int minRow;
            try {
                minRow = rowRange.getLeftBound();
                maxRow = rowRange.getRightBound();
                minColumn = columnRange.getLeftBound();
                maxColumn = columnRange.getRightBound();
            }
            catch (Exception e) {
                return "This block contains no data.";
            }
            if (minRow == maxRow && minColumn == maxColumn) {
                return "(" + heatmap.getRowName(minRow) + "," + heatmap.getColumnName(minColumn) + ") = " + heatmap.get(minRow, minColumn);
            }
            double averageValue = 0.0;
            int blockCount = 0;
            for (int rowCounter = minRow; rowCounter <= maxRow; ++rowCounter) {
                int columnCounter = minColumn;
                while (columnCounter <= maxColumn) {
                    averageValue += heatmap.get(rowCounter, columnCounter);
                    ++columnCounter;
                    ++blockCount;
                }
            }
            return "(" + heatmap.getRowName(minRow) + "," + heatmap.getColumnName(minColumn) + ") .. " + "(" + heatmap.getRowName(maxRow) + "," + heatmap.getColumnName(maxColumn) + ") = " + (averageValue /= (double)blockCount) + " (contains " + (blockCount + 1) + " blocks)";
        }
    }
}

