/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.ThreadUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VisualisationTaskManager {
    private static final Logger logger = Logger.getLogger(VisualisationTaskManager.class);
    private LinkedList<Runnable> workQueue = new LinkedList();
    private Lock workQueueLock = new ReentrantLock();
    private Condition guiWorkAvailable = this.workQueueLock.newCondition();
    private ClientApplication application = Session.getSession().getApplication();
    private VisualisationFrameManager frameManager;

    public VisualisationTaskManager(VisualisationFrameManager frameManager) {
        this.frameManager = frameManager;
        Thread thread = ThreadUtils.getLowPriorityBackgroundThread(new GuiWorker());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualise(VisualisationMethodChangedEvent e) {
        this.workQueueLock.lock();
        try {
            this.workQueue.add(new VisualisationRunnable(e));
            this.guiWorkAvailable.signalAll();
        }
        finally {
            this.workQueueLock.unlock();
        }
    }

    private class GuiWorker
    implements Runnable {
        private GuiWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!Thread.currentThread().isDaemon()) {
                throw new IllegalThreadStateException("GuiWorker must be run on daemon thread");
            }
            while (true) {
                Runnable visualisationRunnable = null;
                VisualisationTaskManager.this.workQueueLock.lock();
                try {
                    if (!VisualisationTaskManager.this.workQueue.isEmpty()) {
                        visualisationRunnable = (Runnable)VisualisationTaskManager.this.workQueue.getFirst();
                        VisualisationTaskManager.this.workQueue.clear();
                    }
                }
                finally {
                    VisualisationTaskManager.this.workQueueLock.unlock();
                }
                if (visualisationRunnable != null) {
                    visualisationRunnable.run();
                    continue;
                }
                VisualisationTaskManager.this.workQueueLock.lock();
                try {
                    VisualisationTaskManager.this.guiWorkAvailable.awaitUninterruptibly();
                    continue;
                }
                finally {
                    VisualisationTaskManager.this.workQueueLock.unlock();
                    continue;
                }
                break;
            }
        }
    }

    private class UpdateGuiRunnable
    implements Runnable {
        private JComponent visualisation;
        private VisualisationMethodChangedEvent event;

        public UpdateGuiRunnable(JComponent visualisation, VisualisationMethodChangedEvent event) {
            this.visualisation = visualisation;
            this.event = event;
        }

        public void run() {
            VisualisationTaskManager.this.frameManager.showVisualisationComponent(this.visualisation, this.event);
        }
    }

    private class VisualisationRunnable
    implements Runnable {
        private VisualisationMethodChangedEvent event;

        public VisualisationRunnable(VisualisationMethodChangedEvent event) {
            this.event = event;
        }

        public void run() {
            long startTime = System.currentTimeMillis();
            JComponent visualisation = this.event.getNewMethod() != null ? VisualisationTaskManager.this.frameManager.createVisualisation(this.event) : null;
            try {
                SwingUtilities.invokeAndWait(new UpdateGuiRunnable(visualisation, this.event));
            }
            catch (InterruptedException e) {
                VisualisationTaskManager.this.application.reportException(e);
            }
            catch (InvocationTargetException e) {
                VisualisationTaskManager.this.application.reportException(e);
            }
            if (logger.isDebugEnabled() && this.event.getDatas().size() > 0 && this.event.getNewMethod() != VisualisationMethod.NONE) {
                long endTime = System.currentTimeMillis();
                Table rowCounter = null;
                try {
                    rowCounter = this.event.getDatas().get(0).queryFeatures("/column/*").asTable();
                }
                catch (MicroarrayException e) {
                    e.printStackTrace();
                }
                int rowCount = 0;
                while (rowCounter.nextRow()) {
                    ++rowCount;
                }
                logger.debug((Object)("\tMethod\t" + (Object)((Object)this.event.getNewMethod()) + "\tDatas\t" + this.event.getDatas().size() + "\tRows\t" + rowCount + "\tByteLength\t" + this.event.getDatas().get(0).getContentLength() + "\tTime\t" + (endTime - startTime) + "\tTime/ByteLength\t" + (float)(endTime - startTime) / (float)this.event.getDatas().get(0).getContentLength() + "\t"));
            }
        }
    }
}

