/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.NonScalableChartPanel;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Color;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Visualisation {
    public static final Dimension PARAMETER_SIZE = new Dimension(150, 500);
    private VisualisationFrame frame;
    public final ClientApplication application = Session.getSession().getApplication();

    public abstract JComponent getVisualisation(DataBean var1) throws Exception;

    public abstract boolean canVisualise(DataBean var1) throws MicroarrayException;

    public Visualisation(VisualisationFrame frame) {
        this.frame = frame;
    }

    public VisualisationFrame getFrame() {
        return this.frame;
    }

    public JPanel getParameterPanel() {
        return null;
    }

    public JComponent getVisualisation(List<DataBean> data) throws Exception {
        throw new NotImplementedException();
    }

    protected JComponent getDefaultVisualisation() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        return panel;
    }

    public static void fillCompoBox(JComboBox box, Object[] content) {
        box.removeAllItems();
        for (Object o : content) {
            box.addItem(o);
        }
    }

    public Variable[] getVariablesFor(DataBean dataBean) {
        LinkedList vars = new LinkedList();
        return vars.toArray(new Variable[0]);
    }

    public static ChartPanel makePanel(JFreeChart chart) {
        ChartPanel panel = new ChartPanel(chart);
        if (chart.getTitle() != null) {
            chart.getTitle().setFont(VisualConstants.VISUALISATION_TITLE_FONT);
        }
        return panel;
    }

    public static ChartPanel makenNonScalablePanel(JFreeChart chart) {
        NonScalableChartPanel panel = new NonScalableChartPanel(chart);
        if (chart.getTitle() != null) {
            chart.getTitle().setFont(VisualConstants.VISUALISATION_TITLE_FONT);
        }
        return panel;
    }

    public boolean canVisualise(List<DataBean> beans) throws MicroarrayException {
        throw new NotImplementedException();
    }

    public boolean isForSingleData() {
        return true;
    }

    public boolean isForMultipleDatas() {
        return false;
    }

    public void removeVisualisation() {
    }

    public static class PlotDescription {
        public String plotTitle;
        public String xTitle;
        public String yTitle;

        public PlotDescription(String plotTitle, String xTitle, String yTitle) {
            this.plotTitle = plotTitle;
            this.xTitle = xTitle;
            this.yTitle = yTitle;
        }
    }

    public static class Variable {
        private String name;
        private String expression;

        public Variable(String name, String expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof Variable && ((Variable)obj).name.equals(this.name) && ((Variable)obj).expression.equals(this.expression);
        }
    }
}

