/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.screen;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.screen.ScreenBase;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.biobeans.BioBean;
import fi.csc.microarray.description.VVSADLParser;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.GeneralFileFilter;
import fi.csc.microarray.util.Strings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class HistoryScreen
extends ScreenBase
implements ActionListener,
CaretListener,
ClientApplication.SourceCodeListener {
    private static final Logger logger = Logger.getLogger(HistoryScreen.class);
    private static final Dimension BUTTON_SIZE = new Dimension(100, 25);
    private static final ClientApplication application = Session.getSession().getApplication();
    private JFrame frame;
    private JTextArea textArea;
    private Map<String, JCheckBox> checkBoxes = new HashMap<String, JCheckBox>();
    private JButton saveButton;
    private JButton closeButton;
    private DataBean data;
    private String[] sourceCodes = null;
    private JFileChooser chooser = null;

    public HistoryScreen() {
        this.frame = new JFrame("History");
        JPanel contentPane = new JPanel(new GridBagLayout());
        this.checkBoxes.put("title", new JCheckBox("Step title"));
        this.checkBoxes.put("name", new JCheckBox("Dataset Name"));
        this.checkBoxes.put("date", new JCheckBox("Creation Date"));
        this.checkBoxes.put("oper", new JCheckBox("Applied analysis tool"));
        this.checkBoxes.put("param", new JCheckBox("Parameters"));
        this.checkBoxes.put("notes", new JCheckBox("User Notes"));
        this.checkBoxes.put("code", new JCheckBox("Source Code"));
        for (JCheckBox box : this.checkBoxes.values()) {
            box.setSelected(true);
            box.addActionListener(this);
        }
        this.checkBoxes.get("notes").setSelected(false);
        this.checkBoxes.get("date").setSelected(false);
        this.checkBoxes.get("code").setSelected(false);
        this.checkBoxes.get("param").setEnabled(this.checkBoxes.get("oper").isSelected());
        this.checkBoxes.get("code").setEnabled(this.checkBoxes.get("oper").isSelected());
        this.saveButton = new JButton("Save...");
        this.saveButton.setPreferredSize(BUTTON_SIZE);
        this.saveButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setPreferredSize(BUTTON_SIZE);
        this.closeButton.addActionListener(this);
        this.textArea = new JTextArea();
        this.textArea.setText(this.getHistoryText());
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.addCaretListener(this);
        JScrollPane textAreaScroller = new JScrollPane(this.textArea);
        textAreaScroller.setPreferredSize(new Dimension(500, 250));
        JLabel topLabel = new JLabel("Show for Datasets:");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets.set(10, 2, 1, 2);
        c.gridx = 0;
        c.gridy = 0;
        contentPane.add((Component)topLabel, c);
        c.insets.set(1, 2, 0, 10);
        c.gridwidth = 1;
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("title"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("name"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("date"), c);
        ++c.gridx;
        c.gridy = 1;
        contentPane.add((Component)this.checkBoxes.get("oper"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("param"), c);
        ++c.gridy;
        contentPane.add((Component)this.checkBoxes.get("code"), c);
        ++c.gridx;
        c.gridy = 1;
        c.insets.set(1, 2, 0, 2);
        contentPane.add((Component)this.checkBoxes.get("notes"), c);
        c.insets.set(10, 2, 1, 2);
        c.gridx = 0;
        c.gridy += 3;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        contentPane.add((Component)textAreaScroller, c);
        c.insets.set(2, 2, 2, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        contentPane.add((Component)this.saveButton, c);
        ++c.gridx;
        c.anchor = 13;
        contentPane.add((Component)this.closeButton, c);
        this.frame.setContentPane(contentPane);
        this.frame.pack();
        this.frame.setResizable(true);
        this.frame.setLocationRelativeTo(null);
    }

    public void setData(DataBean data) {
        this.data = data;
        this.sourceCodes = null;
        this.refreshText();
    }

    private void refreshText() {
        this.textArea.setText(this.getHistoryText());
    }

    private String getHistoryText() {
        if (this.data == null) {
            return null;
        }
        StringBuffer historyText = new StringBuffer();
        int i = 0;
        for (DataBean listData : new BioBean(this.data).getSourcePath()) {
            String notes;
            block18: {
                if (this.checkBoxes.get("title").isSelected()) {
                    String title = "Step " + (i + 1);
                    historyText.append(title + "\n");
                    historyText.append(Strings.repeat("-", title.length()) + "\n\n");
                }
                if (this.checkBoxes.get("name").isSelected()) {
                    historyText.append("Dataset name: " + listData.getName() + "\n");
                }
                if (this.checkBoxes.get("date").isSelected()) {
                    historyText.append("Created " + listData.getDate().toString() + "\n");
                }
                if (this.checkBoxes.get("oper").isSelected()) {
                    Operation oper = listData.getOperation();
                    historyText.append("Created with operation: ");
                    if (oper != null) {
                        historyText.append(oper.getName() + "\n");
                        if (this.checkBoxes.get("param").isSelected()) {
                            LinkedList<Parameter> params = oper.getParameters();
                            if (params != null && params.size() > 0) {
                                for (Parameter param : params) {
                                    historyText.append("Parameter " + param.getName() + ": " + param.getValue() + "\n");
                                }
                            }
                        } else {
                            historyText.append("\n");
                        }
                        if (this.checkBoxes.get("code").isSelected()) {
                            try {
                                String[] sources = this.getSourceCodes();
                                if (sources[i] != null) {
                                    historyText.append("Operation source code:\n" + Strings.indent(sources[i], 4) + "\n");
                                    break block18;
                                }
                                historyText.append("Operation source code: <not available>\n");
                            }
                            catch (MicroarrayException e) {
                                Session.getSession().getApplication().reportException(e);
                            }
                        }
                    } else {
                        historyText.append("<last operation unknown>\n");
                    }
                }
            }
            if (this.checkBoxes.get("notes").isSelected() && (notes = listData.getNotes()) != null) {
                historyText.append("Notes: " + notes + "\n");
            }
            if (listData != this.data) {
                historyText.append("\n");
            }
            ++i;
        }
        this.saveButton.setEnabled(true);
        return historyText.toString();
    }

    private String[] getSourceCodes() throws MicroarrayException {
        if (this.sourceCodes == null) {
            LinkedList<String> names = new LinkedList<String>();
            for (DataBean bean : new BioBean(this.data).getSourcePath()) {
                OperationDefinition op = bean.getOperation().getDefinition();
                if (op.hasSourceCode()) {
                    names.add(VVSADLParser.generateOperationIdentifier(op.getCategoryName(), op.getName()));
                } else {
                    names.add(null);
                }
                logger.debug((Object)("added source path " + (String)names.get(names.size() - 1)));
            }
            this.sourceCodes = new String[names.size()];
            application.fetchSourceFor(names.toArray(new String[1]), this);
        }
        return this.sourceCodes;
    }

    private boolean exportToText() {
        int ret;
        if (this.chooser == null) {
            this.chooser = ImportUtils.getFixedFileChooser();
            GeneralFileFilter filter = new GeneralFileFilter("Text Files", new String[]{"txt"});
            this.chooser.setFileFilter(filter);
        }
        if ((ret = this.chooser.showSaveDialog(null)) == 0) {
            File selectedFile = this.chooser.getSelectedFile();
            if (selectedFile.exists() && JOptionPane.showConfirmDialog(this.frame, "Really overwrite " + selectedFile.getName() + "?", "Save", 0) != 0) {
                return false;
            }
            try {
                String[] lines;
                PrintWriter writer = new PrintWriter(selectedFile);
                String text = this.textArea.getText();
                for (String line : lines = text.split("\n")) {
                    writer.print(line);
                    writer.println();
                }
                writer.flush();
                writer.close();
                return true;
            }
            catch (IOException e) {
                application.reportException(e);
                return false;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBox) {
            if (source == this.checkBoxes.get("oper")) {
                this.checkBoxes.get("param").setEnabled(this.checkBoxes.get("oper").isSelected());
                this.checkBoxes.get("code").setEnabled(this.checkBoxes.get("oper").isSelected());
            }
            this.textArea.setText(this.getHistoryText());
        } else if (source == this.saveButton) {
            if (this.exportToText()) {
                this.saveButton.setEnabled(false);
            }
        } else if (source == this.closeButton) {
            this.frame.dispose();
        }
    }

    public void caretUpdate(CaretEvent e) {
        this.saveButton.setEnabled(true);
    }

    public boolean hasFrame() {
        return this.frame != null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void updateSourceCodeAt(int index, String sourceString) {
        logger.debug((Object)("updating source at " + index + " with " + (sourceString != null ? "string of length " + sourceString.length() : "<null>")));
        this.sourceCodes[index] = sourceString;
        this.refreshText();
    }
}

