/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.IntegerParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntegerInputComponent
extends ParameterInputComponent
implements CaretListener,
ChangeListener {
    private JSpinner spinner;
    private JFormattedTextField field;
    private IntegerParameter param;
    private int state;

    public IntegerInputComponent(IntegerParameter param, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.param = param;
        this.state = 0;
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setValue(param.getIntegerValue());
        this.spinner = new JSpinner(model);
        this.spinner.addFocusListener(this);
        this.spinner.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.spinner.setEditor(new JSpinner.NumberEditor(this.spinner, "0"));
        this.spinner.addChangeListener(this);
        this.field = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        this.field.addCaretListener(this);
        this.add((Component)this.spinner, "Center");
    }

    public Parameter getParameter() {
        return this.param;
    }

    public boolean inputIsValid() {
        return this.state == 0 || this.state == 1;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spinner) {
            SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spinner.getModel();
            int value = numberModel.getNumber().intValue();
            if (this.param.checkValidityOf(value)) {
                this.param.setValue(value);
                this.setState(1);
            } else {
                this.setState(-1);
            }
        }
    }

    public void caretUpdate(CaretEvent e) {
        try {
            Integer value = null;
            if (this.spinner.getModel() instanceof SpinnerNumberModel) {
                value = new Integer(((SpinnerNumberModel)this.spinner.getModel()).getNumber().intValue());
            }
            if (this.param.checkValidityOf(value)) {
                this.setState(1);
                this.param.setValue(value);
            } else {
                this.setState(-1);
            }
        }
        catch (NumberFormatException nfe) {
            this.setState(-2);
        }
    }

    private void setState(int newState) {
        String message = null;
        this.state = newState;
        switch (this.state) {
            case 1: {
                this.field.setBackground(ParameterInputComponent.BG_VALID);
                this.field.setForeground(Color.black);
                message = this.param.getDescription();
                this.getParentPanel().setMessage(message, Color.black);
                break;
            }
            case -1: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                this.field.setForeground(Color.black);
                message = "Value for " + this.param.getName() + " must be between " + this.param.getMinValue() + " and " + this.param.getMaxValue() + ".";
                this.getParentPanel().setMessage(message, Color.red);
                break;
            }
            case -2: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                this.field.setForeground(Color.red);
                message = "Value for " + this.param.getName() + " must be a valid integer.";
                this.getParentPanel().setMessage(message, Color.red);
            }
        }
    }

    public JComponent getParameterComponent() {
        return this.spinner;
    }

    public void focusGained(FocusEvent e) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }
}

