/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.DecimalParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class DecimalInputComponent
extends ParameterInputComponent
implements CaretListener {
    private JTextField field;
    private DecimalParameter param;
    private int state;

    public DecimalInputComponent(DecimalParameter param, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.param = param;
        this.field = new JTextField();
        this.field.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.field.setText("" + param.getDecimalValue());
        this.field.addCaretListener(this);
        this.field.addFocusListener(this);
        this.add((Component)this.field, "Center");
        this.state = 0;
    }

    public Parameter getParameter() {
        return this.param;
    }

    public boolean inputIsValid() {
        return this.state == 0 || this.state == 1;
    }

    public void caretUpdate(CaretEvent e) {
        try {
            double value = Double.parseDouble(this.field.getText());
            if (this.param.checkValidityOf(value)) {
                this.setState(1);
                this.param.setValue(value);
            } else {
                this.setState(-1);
            }
        }
        catch (NumberFormatException nfe) {
            this.setState(-2);
        }
    }

    private void setState(int newState) {
        String message = null;
        this.state = newState;
        switch (this.state) {
            case 1: {
                this.field.setBackground(ParameterInputComponent.BG_VALID);
                this.field.setForeground(Color.black);
                message = this.param.getDescription();
                this.getParentPanel().setMessage(message, Color.black);
                break;
            }
            case -1: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                this.field.setForeground(Color.black);
                message = "Value for " + this.param.getName() + " must be between " + this.param.getMinValue() + " and " + this.param.getMaxValue() + ".";
                this.getParentPanel().setMessage(message, Color.red);
                break;
            }
            case -2: {
                this.field.setBackground(ParameterInputComponent.BG_INVALID);
                this.field.setForeground(Color.red);
                message = "Value for " + this.param.getName() + " must be a valid " + "decimal number. Use a point as the decimal separator.";
                this.getParentPanel().setMessage(message, Color.red);
            }
        }
    }

    public JComponent getParameterComponent() {
        return this.field;
    }

    public void focusGained(FocusEvent e) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }
}

