/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.SingleSelectionParameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.LinkedList;

public abstract class DataSelectionParameter
extends SingleSelectionParameter {
    protected String initValue;

    public DataSelectionParameter(String name, String description, String initValue) {
        super(name, description);
        this.initValue = initValue;
    }

    protected void loadOptionsFromColumnNames(DataBean data) throws MicroarrayException {
        int initIndex = 0;
        LinkedList<String> colNames = new LinkedList<String>();
        if (data != null) {
            Table columns = data.queryFeatures("/column/*").asTable();
            for (String columnName : columns.getColumnNames()) {
                colNames.add(columnName);
            }
        }
        colNames.add("EMPTY");
        for (int i = 0; i < colNames.size(); ++i) {
            if (!((String)colNames.get(i)).equals(this.initValue)) continue;
            initIndex = i;
            break;
        }
        String[] strings = colNames.toArray(new String[colNames.size()]);
        SingleSelectionParameter.SelectionOption[] optionObjects = SingleSelectionParameter.SelectionOption.convertStrings(strings);
        this.setOptions(optionObjects, initIndex);
    }
}

