/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXHyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickLinkPanel
extends JPanel
implements ActionListener {
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();
    private JXHyperlink sessionLink;
    private JXHyperlink importLink;
    private JXHyperlink emptyLink;
    private JXHyperlink exampleLink;
    private JXHyperlink importFolderLink;
    private JXHyperlink importURLLink;
    private JXHyperlink importArrayExpressLink;
    private JXHyperlink importGEOLink;
    private static final String LINK_WORD = "***";

    public QuickLinkPanel() {
        super(new GridBagLayout());
        this.setBackground(Color.white);
        this.exampleLink = this.createLink("Open example session ");
        this.importLink = this.createLink("Import files ");
        this.importFolderLink = this.createLink("Import folder ");
        this.importURLLink = this.createLink("Import from URL ");
        this.importArrayExpressLink = this.createLink("Import from ArrayExpress ");
        this.importGEOLink = this.createLink("Import from GEO ");
        this.sessionLink = this.createLink("Open session ");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.insets.set(5, 10, 5, 10);
        c.gridwidth = 2;
        this.add((Component)new JLabel("To start working with Chipster, you need to load in data first:"), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.insets.set(0, 10, 0, 0);
        this.addLink("*** to get familiar with Chipster.", this.exampleLink, VisualConstants.EXAMPLE_SESSION_ICON, c);
        this.addLink("*** to continue working on previous sessions.", this.sessionLink, VisualConstants.OPEN_SESSION_LINK_ICON, c);
        LinkedList<JXHyperlink> importLinks = new LinkedList<JXHyperlink>();
        importLinks.add(this.importLink);
        importLinks.add(this.importFolderLink);
        importLinks.add(this.importURLLink);
        importLinks.add(this.importArrayExpressLink);
        importLinks.add(this.importGEOLink);
        this.addLink("Import new data to Chipster: \n      *** \n      *** \n      *** \n      *** \n      ***", importLinks, VisualConstants.IMPORT_LINK_ICON, c);
        JPanel bottomPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        bottomPanel.setBackground(Color.white);
        rightPanel.setBackground(Color.white);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)bottomPanel, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 0;
        this.add((Component)rightPanel, c);
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(360, 250));
    }

    private void addLink(String description, JXHyperlink link, ImageIcon icon, GridBagConstraints c) {
        LinkedList<JXHyperlink> list = new LinkedList<JXHyperlink>();
        list.add(link);
        this.addLink(description, list, icon, c);
    }

    private void addLink(String description, List<JXHyperlink> links, ImageIcon icon, GridBagConstraints c) {
        String[] words = description.split(" ");
        int rowChars = 0;
        int MAX_ROW_CHARS = 40;
        Iterator<JXHyperlink> linkIterator = links.iterator();
        int rowCount = 0;
        c.gridx = 1;
        c.insets.top = 10;
        JPanel row = null;
        for (int i = 0; i < words.length; ++i) {
            if (row == null || rowChars + words[i].length() > 40 || words[i].equals("\n")) {
                FlowLayout flow = new FlowLayout(3);
                flow.setVgap(0);
                flow.setHgap(0);
                row = new JPanel(flow);
                row.setBackground(Color.white);
                ++c.gridy;
                this.add((Component)row, c);
                c.insets.top = 0;
                rowChars = 0;
                ++rowCount;
            }
            if (words[i].equals(LINK_WORD)) {
                JXHyperlink link = linkIterator.next();
                rowChars += link.getText().length() + 1;
                row.add((Component)link);
                continue;
            }
            if (words[i].equals("\n")) continue;
            JLabel text = new JLabel(words[i] + " ");
            row.add(text);
            rowChars += words[i].length() + 1;
        }
        c.gridy -= rowCount - 1;
        c.gridheight = rowCount;
        c.gridx = 0;
        c.insets.top = 15;
        this.add((Component)new JLabel(icon), c);
        c.gridy += rowCount - 1;
        c.gridheight = 1;
    }

    private JXHyperlink createLink(String text) {
        JXHyperlink link = new JXHyperlink();
        link.setText(text);
        link.addActionListener((ActionListener)this);
        link.setBorder(null);
        link.setMargin(new Insets(0, 0, 0, 0));
        return link;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.sessionLink) {
                this.application.loadSession();
            } else if (e.getSource() == this.importLink) {
                this.application.openFileImport();
            } else if (e.getSource() == this.importURLLink) {
                this.application.openURLImport();
            } else if (e.getSource() == this.importFolderLink) {
                this.application.openDirectoryImportDialog();
            } else if (e.getSource() == this.importArrayExpressLink) {
                Operation importOperation = new Operation(this.application.locateOperationDefinition("Utilities", "Import from ArrayExpress"), new DataBean[0]);
                this.application.openDatabaseImport("ArrayExpress", importOperation);
            } else if (e.getSource() == this.importGEOLink) {
                Operation importOperation = new Operation(this.application.locateOperationDefinition("Utilities", "Import from GEO"), new DataBean[0]);
                this.application.openDatabaseImport("GEO", importOperation);
            } else if (e.getSource() != this.emptyLink && e.getSource() == this.exampleLink) {
                URL url = new URL("https://extras.csc.fi/biosciences/chipster-manual/IlluminaHuman6v1teratospermia.cs");
                this.application.loadSessionFrom(url);
            }
        }
        catch (Exception ex) {
            this.application.reportException(ex);
        }
    }
}

