/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.analyser.bsh.BeanShellJobInfo;
import fi.csc.microarray.messaging.JobState;
import org.apache.log4j.Logger;

public class BeanShellJob
extends OnDiskAnalysisJobBase {
    private static final Logger logger = Logger.getLogger(BeanShellJob.class);

    protected void execute() throws JobCancelledException {
        this.updateStateDetailToClient("preparing BeanShell");
        BeanShellJobInfo jobInfo = new BeanShellJobInfo();
        jobInfo.workDir = this.jobWorkDir;
        int i = 0;
        for (AnalysisDescription.ParameterDescription param : this.analysis.getParameters()) {
            jobInfo.parameters.put(param.getName(), this.inputMessage.getParameters().get(i));
            ++i;
        }
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("jobInfo", (Object)jobInfo);
            this.updateStateDetailToClient("running the BeanShell script");
            interpreter.eval(this.analysis.getSourceCode());
        }
        catch (TargetError te) {
            String errorMessage = "Running the BeanShell script failed.";
            logger.warn((Object)errorMessage, (Throwable)te);
            this.outputMessage.setErrorMessage(errorMessage);
            this.outputMessage.setOutputText(te.toString());
            this.updateState(JobState.FAILED, "");
            return;
        }
        catch (EvalError ee) {
            String errorMessage = "The BeanShell script could not be evaluated.";
            this.outputMessage.setErrorMessage(errorMessage);
            this.outputMessage.setOutputText(ee.toString());
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.updateState(JobState.RUNNING, "BeanShell finished succesfully");
    }

    protected void cancelRequested() {
    }
}

