/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import java.util.ArrayList;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.perf.PerfProducer;
import org.apache.activemq.perf.SimpleQueueTest;

public class SimpleNonPersistentQueueTest
extends SimpleQueueTest {
    protected void setUp() throws Exception {
        this.numberOfConsumers = 10;
        this.numberofProducers = 10;
        super.setUp();
    }

    protected PerfProducer createProducer(ConnectionFactory fac, Destination dest, int number, byte[] payload) throws JMSException {
        PerfProducer pp = new PerfProducer(fac, dest, payload);
        pp.setDeliveryMode(1);
        return pp;
    }

    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        answer.setPersistent(false);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setMemoryLimit(0x100000L);
        entry.setOptimizedDispatch(true);
        entry.setLazyDispatch(true);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        answer.setDestinationPolicy(policyMap);
        super.configureBroker(answer, uri);
    }
}

