/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.activemq.spring.ActiveMQConnectionFactory;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jms.JmsConsumer;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.processor.Logger;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public class ActiveMQConfigureTest
extends ContextTestSupport {
    public void testJmsTemplateUsesPoolingConnectionFactory() throws Exception {
        JmsEndpoint endpoint = this.resolveMandatoryEndpoint("activemq:test.foo");
        JmsProducer producer = endpoint.createProducer();
        JmsTemplate template = (JmsTemplate)this.assertIsInstanceOf(JmsTemplate.class, producer.getTemplate());
        ActiveMQConfigureTest.assertEquals((String)"pubSubDomain", (boolean)false, (boolean)template.isPubSubDomain());
        this.assertIsInstanceOf(PooledConnectionFactory.class, template.getConnectionFactory());
    }

    public void testJmsTemplateUsesSingleConnectionFactory() throws Exception {
        JmsEndpoint endpoint = this.resolveMandatoryEndpoint("activemq:test.foo?useSingleConnection=true");
        JmsProducer producer = endpoint.createProducer();
        JmsTemplate template = (JmsTemplate)this.assertIsInstanceOf(JmsTemplate.class, producer.getTemplate());
        ActiveMQConfigureTest.assertEquals((String)"pubSubDomain", (boolean)false, (boolean)template.isPubSubDomain());
        SingleConnectionFactory connectionFactory = (SingleConnectionFactory)this.assertIsInstanceOf(SingleConnectionFactory.class, template.getConnectionFactory());
        this.assertIsInstanceOf(ActiveMQConnectionFactory.class, connectionFactory.getTargetConnectionFactory());
    }

    public void testJmsTemplateDoesNotUsePoolingConnectionFactory() throws Exception {
        JmsEndpoint endpoint = this.resolveMandatoryEndpoint("activemq:test.foo?usePooledConnection=false");
        JmsProducer producer = endpoint.createProducer();
        JmsTemplate template = (JmsTemplate)this.assertIsInstanceOf(JmsTemplate.class, producer.getTemplate());
        ActiveMQConfigureTest.assertEquals((String)"pubSubDomain", (boolean)false, (boolean)template.isPubSubDomain());
        this.assertIsInstanceOf(ActiveMQConnectionFactory.class, template.getConnectionFactory());
    }

    public void testListenerContainerUsesSpringConnectionFactory() throws Exception {
        JmsEndpoint endpoint = this.resolveMandatoryEndpoint("activemq:topic:test.foo");
        JmsConsumer consumer = endpoint.createConsumer((Processor)new Logger());
        AbstractMessageListenerContainer listenerContainer = consumer.getListenerContainer();
        ActiveMQConfigureTest.assertEquals((String)"pubSubDomain", (boolean)true, (boolean)listenerContainer.isPubSubDomain());
        this.assertIsInstanceOf(PooledConnectionFactory.class, listenerContainer.getConnectionFactory());
    }

    protected JmsEndpoint resolveMandatoryEndpoint(String uri) {
        Endpoint endpoint = super.resolveMandatoryEndpoint(uri);
        return (JmsEndpoint)this.assertIsInstanceOf(JmsEndpoint.class, endpoint);
    }
}

