/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.HeatMapAxis;
import org.jfree.chart.editor.ChartEditorManager;
import org.jfree.chart.editor.GradientColorPaletteEditor;
import org.jfree.chart.editor.HCOptionsEditor;
import org.jfree.chart.editor.ViskiChartEditorFactory;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.entity.HeatMapBlockEntity;
import org.jfree.chart.event.ClusteringTreeChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.HCToolTipGenerator;
import org.jfree.chart.plot.AbstractHCClusteringInfo;
import org.jfree.chart.plot.DummyHCClusteringInfo;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.chart.plot.HCMediator;
import org.jfree.chart.plot.HCPlotState;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.StandardHCClusteringInfo;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.ui.RectangleEdge;

public class HCPlot
extends Plot
implements ChartMouseListener,
ChangeListener {
    private HCDataset dataset;
    private HeatMapAxis rowNames;
    private HeatMapAxis columnNames;
    private AbstractHCClusteringInfo rowClusteringInfo;
    private AbstractHCClusteringInfo columnClusteringInfo;
    private boolean columnNamesVisibility;
    private boolean rowNamesVisibility;
    private boolean columnTreeVisibility;
    private boolean rowTreeVisibility;
    private double columnTreeSize;
    private double rowTreeSize;
    private double columnNamesSize;
    private double rowNamesSize;
    private double topMarginSize;
    private double bottomMarginSize;
    private double leftMarginSize;
    private double rightMarginSize;
    private GradientColorPalette palette;
    private GradientColorPaletteEditor paletteEditor;
    private HCOptionsEditor optionsEditor;
    public static final int LEFT = 0;
    public static final int TOP = 1;
    private HCToolTipGenerator toolTipGenerator;
    private boolean mouseOverHighlight;
    private int columnTreeHighlight;
    private int rowTreeHighlight;
    private boolean selectionHighlight;
    private boolean averageHighlight;
    private TreeSet<Integer> closedRows;
    private TreeSet<Integer> closedColumns;
    private boolean drawFromLeftToRight;
    private boolean drawFromTopToBottom;
    private Selection[] selected;
    private int SELECTION_ALPHA = 128;
    private int SELECTION_PARTIAL_ALPHA = 192;
    private boolean isRowSelection;

    public HCPlot(HCDataset dataset) {
        this.dataset = dataset;
        this.columnNamesVisibility = true;
        this.rowNamesVisibility = true;
        if (this.dataset.getColumnClusteringTree() != null) {
            this.columnClusteringInfo = new StandardHCClusteringInfo(this.dataset.getColumnClusteringTree(), this.dataset.getHeatMap().getColumnNames(), 1);
            this.columnTreeVisibility = true;
        } else {
            this.columnClusteringInfo = new DummyHCClusteringInfo(this.dataset.getHeatMap().getColumnNames(), 1);
            this.columnTreeVisibility = false;
        }
        if (this.dataset.getRowClusteringTree() != null) {
            this.rowClusteringInfo = new StandardHCClusteringInfo(this.dataset.getRowClusteringTree(), this.dataset.getHeatMap().getRowNames(), 0);
            this.rowTreeVisibility = true;
        } else {
            this.rowClusteringInfo = new DummyHCClusteringInfo(this.dataset.getHeatMap().getRowNames(), 0);
            this.rowTreeVisibility = false;
        }
        HCMediator columnHCMediator = new HCMediator(this.columnClusteringInfo);
        this.columnClusteringInfo.addChangeListener(this);
        HCMediator rowHCMediator = new HCMediator(this.rowClusteringInfo);
        this.rowClusteringInfo.addChangeListener(this);
        this.rowNames = new HeatMapAxis();
        this.rowNames.setPlot(rowHCMediator);
        this.rowNames.setLowerMargin(0.0);
        this.rowNames.setUpperMargin(0.0);
        this.rowNames.setMaximumCategoryLabelWidthRatio(0.95f);
        this.columnNames = new HeatMapAxis();
        this.columnNames.setPlot(columnHCMediator);
        this.columnNames.setLowerMargin(0.0);
        this.columnNames.setUpperMargin(0.0);
        this.columnNames.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        this.columnNames.setMaximumCategoryLabelWidthRatio(0.95f);
        this.optionsEditor = new HCOptionsEditor(this);
        this.paletteEditor = new GradientColorPaletteEditor();
        this.palette = null;
        this.closedColumns = new TreeSet();
        this.closedRows = new TreeSet();
        this.rowNamesSize = 150.0;
        this.columnNamesSize = 150.0;
        this.topMarginSize = 10.0;
        this.leftMarginSize = 10.0;
        this.columnTreeSize = (int)(Math.log(dataset.getHeatMap().getColumnsCount()) / Math.log(2.0) * 25.0);
        this.rowTreeSize = (int)(Math.log(dataset.getHeatMap().getRowCount()) / Math.log(2.0) * 25.0);
        this.bottomMarginSize = this.topMarginSize;
        this.rightMarginSize = this.leftMarginSize;
        this.mouseOverHighlight = true;
        this.selectionHighlight = true;
        this.averageHighlight = true;
        this.columnTreeHighlight = -1;
        this.rowTreeHighlight = -1;
        this.drawFromLeftToRight = true;
        this.drawFromTopToBottom = true;
    }

    public double getTopMarginSize() {
        return this.topMarginSize;
    }

    public double getBottomMarginSize() {
        return this.bottomMarginSize;
    }

    public double getLeftMarginSize() {
        return this.leftMarginSize;
    }

    public double getRightMarginSize() {
        return this.rightMarginSize;
    }

    public AbstractHCClusteringInfo getColumnClusteringInfo() {
        return this.columnClusteringInfo;
    }

    public AbstractHCClusteringInfo getRowClusteringInfo() {
        return this.rowClusteringInfo;
    }

    public HCDataset getDataset() {
        return this.dataset;
    }

    public String getPlotType() {
        return "Hierarchical Clustering and Heatmap";
    }

    public void showRowTree() {
        if (this.dataset.getRowClusteringTree() == null) {
            throw new NullPointerException("Cannot show a null tree.");
        }
        this.rowTreeVisibility = true;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void showColumnTree() {
        if (this.dataset.getColumnClusteringTree() == null) {
            throw new NullPointerException("Cannot show a null tree.");
        }
        this.columnTreeVisibility = true;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void hideRowTree() {
        if (this.dataset.getRowClusteringTree() == null) {
            throw new NullPointerException("Cannot hide a null tree.");
        }
        this.rowTreeVisibility = false;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void hideColumnTree() {
        if (this.dataset.getColumnClusteringTree() == null) {
            throw new NullPointerException("Cannot hide a null tree.");
        }
        this.columnTreeVisibility = false;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getRowTreeVisibility() {
        if (this.dataset.getRowClusteringTree() == null) {
            return false;
        }
        return this.rowTreeVisibility;
    }

    public boolean getColumnTreeVisibility() {
        if (this.dataset.getColumnClusteringTree() == null) {
            return false;
        }
        return this.columnTreeVisibility;
    }

    public void showColumnNames() {
        this.columnNamesVisibility = true;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void showRowNames() {
        this.rowNamesVisibility = true;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void hideColumnNames() {
        this.columnNamesVisibility = false;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void hideRowNames() {
        this.rowNamesVisibility = false;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getColumnNamesVisibility() {
        return this.columnNamesVisibility;
    }

    public boolean getRowNamesVisibility() {
        return this.rowNamesVisibility;
    }

    public void setColoring(GradientColorPalette color) {
        if (this.palette != null) {
            this.palette.removeChangeListener(this);
        }
        this.palette = color;
        this.palette.addChangeListener(this);
        this.paletteEditor.setColoring(color);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public GradientColorPalette getColoring() {
        return this.palette;
    }

    public void setRowNamesSize(double size) {
        if (size < 0.0) {
            throw new IllegalArgumentException("Size of names cannot be negative.");
        }
        if (size > 1.0) {
            throw new IllegalArgumentException("Size of names cannot be more than 1.");
        }
        this.rowNamesSize = size;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setColumnNamesSize(double size) {
        if (size < 0.0) {
            throw new IllegalArgumentException("Size of names cannot be negative.");
        }
        if (size > 1.0) {
            throw new IllegalArgumentException("Size of names cannot be more than 1.");
        }
        this.columnNamesSize = size;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getRowNamesSize() {
        return this.rowNamesSize;
    }

    public double getColumnNamesSize() {
        return this.columnNamesSize;
    }

    public void setRowTreeSize(double size) {
        if (size < 0.0) {
            throw new IllegalArgumentException("Size of a tree cannot be negative.");
        }
        if (size > 1.0) {
            throw new IllegalArgumentException("Size of a tree cannot be more than 1.");
        }
        this.rowTreeSize = size;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setColumnTreeSize(double size) {
        if (size < 0.0) {
            throw new IllegalArgumentException("Size of a tree cannot be negative.");
        }
        if (size > 1.0) {
            throw new IllegalArgumentException("Size of a tree cannot be more than 1.");
        }
        this.columnTreeSize = size;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getRowTreeSize() {
        return this.rowTreeSize;
    }

    public double getColumnTreeSize() {
        return this.columnTreeSize;
    }

    public void setMouseOverHighlight(boolean highlight) {
        this.mouseOverHighlight = highlight;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getMouseOverHighlight() {
        return this.mouseOverHighlight;
    }

    public void setSelectionHighlight(boolean highlight) {
        this.selectionHighlight = highlight;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getSelectionHighlight() {
        return this.selectionHighlight;
    }

    public void setAverageHighlight(boolean highlight) {
        this.averageHighlight = highlight;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getAverageHighlight() {
        return this.averageHighlight;
    }

    public void setRowTreeHighlight(int index) {
        this.rowTreeHighlight = index;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setColumnTreeHighlight(int index) {
        this.columnTreeHighlight = index;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getRowTreeHighlight() {
        return this.rowTreeHighlight;
    }

    public int getColumnTreeHighlight() {
        return this.columnTreeHighlight;
    }

    public int getHeatMapRowCount() {
        return this.rowClusteringInfo.getNumberOfVisibleItems();
    }

    public int getHeatMapColumnsCount() {
        return this.columnClusteringInfo.getNumberOfVisibleItems();
    }

    public DataRange getDatasetRowsAtHeatMapRow(int row) {
        return this.rowClusteringInfo.getDataRangeForVisibleIndex(row);
    }

    public DataRange getDatasetColumnsAtHeatMapColumn(int column) {
        return this.columnClusteringInfo.getDataRangeForVisibleIndex(column);
    }

    private HCTreeNodeEntity drawSubTree(Graphics2D g2, HCPlotState state, HCTreeNodeInfo node, Rectangle2D area, RectangleEdge edge) {
        Point center;
        Rectangle thisArea;
        if (!node.isNodeOpen()) {
            thisArea = state.calculateClosedNodeArea(area, node, edge);
            center = state.calculateClosedNodeCenter(thisArea, node.getNode().getHeight(), edge);
        } else if (node.getLeftChild() == null || node.getRightChild() == null) {
            thisArea = state.calculateLeafNodeArea(area, node, edge);
            center = state.calculateLeafNodeCenter(thisArea, edge);
        } else {
            HCTreeNodeEntity leftEntity = this.drawSubTree(g2, state, node.getLeftChild(), area, edge);
            Rectangle areaForRightSubTree = state.calculateSubTreeArea(area, leftEntity.getSubTreeArea(), edge);
            HCTreeNodeEntity rightEntity = this.drawSubTree(g2, state, node.getRightChild(), areaForRightSubTree, edge);
            thisArea = state.calculateBranchNodeArea(node.getNode().getHeight(), leftEntity, rightEntity, area, edge);
            center = state.calculateBranchNodeCenter(node.getNode().getHeight(), leftEntity, rightEntity, area, edge);
        }
        String tip = this.toolTipGenerator != null ? this.toolTipGenerator.generateToolTip(node) : null;
        HCTreeNodeEntity thisEntity = new HCTreeNodeEntity(new Rectangle((int)center.getX() - 5, (int)center.getY() - 5, 11, 11), tip, null, center, thisArea, node);
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            entities.add(thisEntity);
        }
        this.redrawNode(g2, state, thisEntity, edge);
        return thisEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void redrawNode(Graphics2D g2, HCPlotState state, HCTreeNodeEntity entity, RectangleEdge edge) {
        int centerX = (int)entity.getCenter().getX();
        int centerY = (int)entity.getCenter().getY();
        Rectangle subTreeArea = entity.getSubTreeArea();
        int width = (int)subTreeArea.getWidth();
        int height = (int)subTreeArea.getHeight();
        int minX = (int)subTreeArea.getMinX();
        int minY = (int)subTreeArea.getMinY();
        int maxX = (int)(subTreeArea.getMinX() + (double)width);
        int maxY = (int)(subTreeArea.getMinY() + (double)height);
        HCTreeNode node = entity.getHCTreeNodeInfo().getNode();
        g2.setPaint(this.getOutlinePaint());
        if (entity.getHCTreeNodeInfo().isNodeOpen()) {
            if (node.getLeftChild() != null && node.getRightChild() != null) {
                double height1 = node.getLeftChild().getHeight();
                double height2 = node.getRightChild().getHeight();
                if (edge == RectangleEdge.TOP) {
                    g2.drawLine(minX, centerY, minX, maxY - (int)(height1 * state.getColumnTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)));
                    g2.drawLine(maxX, centerY, maxX, maxY - (int)(height2 * state.getColumnTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)));
                    g2.drawLine(minX, centerY, maxX, centerY);
                } else if (edge == RectangleEdge.BOTTOM) {
                    g2.drawLine(minX, centerY, minX, minY + (int)(height1 * state.getColumnTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)));
                    g2.drawLine(maxX, centerY, maxX, minY + (int)(height2 * state.getColumnTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)));
                    g2.drawLine(minX, centerY, maxX, centerY);
                } else if (edge == RectangleEdge.LEFT) {
                    g2.drawLine(centerX, minY, maxX - (int)(height1 * state.getRowTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)), minY);
                    g2.drawLine(centerX, maxY, maxX - (int)(height2 * state.getRowTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)), maxY);
                    g2.drawLine(centerX, minY, centerX, maxY);
                } else {
                    if (edge != RectangleEdge.RIGHT) throw new IllegalArgumentException("Invalid edge.");
                    g2.drawLine(centerX, minY, minX + (int)(height1 * state.getRowTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)), minY);
                    g2.drawLine(centerX, maxY, minX + (int)(height2 * state.getRowTreeHeightUnitInPixels() + (double)(state.getSizeOfNodeSymbol() / 2)), maxY);
                    g2.drawLine(centerX, minY, centerX, maxY);
                }
            }
            Rectangle r = new Rectangle(centerX - state.getSizeOfNodeSymbol() / 2, centerY - state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol(), state.getSizeOfNodeSymbol());
            g2.fill(r);
            return;
        } else {
            Rectangle r;
            if (node.getLeftChild() == null || node.getRightChild() == null) {
                if (edge == RectangleEdge.TOP) {
                    r = new Rectangle(centerX - state.getSizeOfNodeSymbol() / 2, centerY - state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol(), state.getSizeOfNodeSymbol() / 2);
                } else if (edge == RectangleEdge.BOTTOM) {
                    r = new Rectangle(centerX - state.getSizeOfNodeSymbol() / 2, centerY, state.getSizeOfNodeSymbol(), state.getSizeOfNodeSymbol() / 2);
                } else if (edge == RectangleEdge.LEFT) {
                    r = new Rectangle(centerX - state.getSizeOfNodeSymbol() / 2, centerY - state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol());
                } else {
                    if (edge != RectangleEdge.RIGHT) throw new IllegalArgumentException("Invalid edge.");
                    r = new Rectangle(centerX, centerY - state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol());
                }
            } else {
                r = new Rectangle(centerX - state.getSizeOfNodeSymbol() / 2, centerY - state.getSizeOfNodeSymbol() / 2, state.getSizeOfNodeSymbol(), state.getSizeOfNodeSymbol());
            }
            if (edge == RectangleEdge.TOP) {
                g2.drawLine(centerX, (int)r.getMaxY(), centerX, maxY);
            } else if (edge == RectangleEdge.BOTTOM) {
                g2.drawLine(centerX, (int)r.getMinY(), centerX, minY);
            } else if (edge == RectangleEdge.LEFT) {
                g2.drawLine((int)r.getMaxX(), centerY, maxX, centerY);
            } else {
                if (edge != RectangleEdge.RIGHT) throw new IllegalArgumentException("Invalid edge.");
                g2.drawLine((int)r.getMinX(), centerY, minX, centerY);
            }
            g2.draw(r);
        }
    }

    private void drawBlock(Graphics2D g2, Rectangle2D area, HCPlotState state, int row, int column) {
        int maxRow;
        int maxColumn;
        int minColumn;
        DataRange columns = this.columnClusteringInfo.getDataRangeForVisibleIndex(column);
        DataRange rows = this.rowClusteringInfo.getDataRangeForVisibleIndex(row);
        try {
            minColumn = columns.getLeftBound();
            maxColumn = columns.getRightBound();
            int minRow = rows.getLeftBound();
            maxRow = rows.getRightBound();
        }
        catch (Exception e) {
            return;
        }
        double averageValue = 0.0;
        int blockCount = 0;
        for (int rowCounter = minRow; rowCounter <= maxRow; ++rowCounter) {
            int columnCounter = minColumn;
            while (columnCounter <= maxColumn) {
                averageValue += this.dataset.getHeatMap().get(rowCounter, columnCounter);
                ++columnCounter;
                ++blockCount;
            }
        }
        Color c = this.palette.getColor(averageValue /= (double)blockCount);
        if (this.isRowSelection) {
            if (this.selected[row] == Selection.YES) {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.SELECTION_ALPHA);
            } else if (this.selected[row] == Selection.PARTIAL) {
                c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.SELECTION_PARTIAL_ALPHA);
            }
        } else if (this.selected[column] == Selection.YES) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.SELECTION_ALPHA);
        }
        g2.setColor(c);
        Rectangle r = new Rectangle(state.getHeatMapXCoordinate(column), state.getHeatMapYCoordinate(row), state.getHeatMapXCoordinate(column + 1) - state.getHeatMapXCoordinate(column), state.getHeatMapYCoordinate(row + 1) - state.getHeatMapYCoordinate(row));
        g2.fill(r);
        if (blockCount > 1 && this.getAverageHighlight()) {
            if (rows.getWidth() > 1) {
                Integer introw = new Integer(row);
                this.closedRows.add(introw);
            }
            if (columns.getWidth() > 1) {
                Integer intcolumn = new Integer(column);
                this.closedColumns.add(intcolumn);
            }
        }
        String tip = this.toolTipGenerator != null ? this.toolTipGenerator.generateToolTip(this.dataset.getHeatMap(), rows, columns) : null;
        HeatMapBlockEntity entity = new HeatMapBlockEntity(r, tip, null, row, column);
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            entities.add(entity);
        }
    }

    private void drawSelection(Graphics2D g2, HCPlotState state, Color color, Rectangle r) {
        g2.setColor(color);
        int column = (int)r.getX();
        int row = (int)r.getY();
        int lastrow = row + (int)r.getHeight() - 1;
        int lastcolumn = column + (int)r.getWidth() - 1;
        g2.draw(new Rectangle(state.getHeatMapXCoordinate(column), state.getHeatMapYCoordinate(row), state.getHeatMapXCoordinate(lastcolumn + 1) - state.getHeatMapXCoordinate(column) - 1, state.getHeatMapYCoordinate(lastrow + 1) - state.getHeatMapYCoordinate(row) - 1));
    }

    private void drawHeatMap(Graphics2D g2, HCPlotState state, Rectangle2D area, int visibleColumns, int visibleRows) {
        int maxRow;
        int maxColumn;
        int minRow;
        int count = 0;
        Rectangle clip = g2.getClip().getBounds();
        int minColumn = (int)Math.floor((clip.getMinX() - area.getMinX()) / state.getBlockWidth());
        if (minColumn < 0) {
            minColumn = 0;
        }
        if ((minRow = (int)Math.floor((clip.getMinY() - area.getMinY()) / state.getBlockHeight())) < 0) {
            minRow = 0;
        }
        if ((maxColumn = (int)Math.ceil((clip.getMaxX() - area.getMinX()) / state.getBlockWidth())) > visibleColumns) {
            maxColumn = visibleColumns;
        }
        if ((maxRow = (int)Math.ceil((clip.getMaxY() - area.getMinY()) / state.getBlockHeight())) > visibleRows) {
            maxRow = visibleRows;
        }
        for (int row = minRow; row < maxRow; ++row) {
            for (int column = minColumn; column < maxColumn; ++column) {
                this.drawBlock(g2, area, state, row, column);
                ++count;
            }
        }
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        Rectangle r;
        int i;
        Color color;
        Integer item;
        Rectangle rowNamesArea;
        Rectangle rowTreeArea;
        Rectangle columnNamesArea;
        Rectangle columnTreeArea;
        RectangleEdge columnNamesLocation;
        RectangleEdge columnTreeLocation;
        int heatMapMinY;
        RectangleEdge rowNamesLocation;
        RectangleEdge rowTreeLocation;
        int heatMapMinX;
        int visibleColumns = this.getHeatMapColumnsCount();
        int visibleRows = this.getHeatMapRowCount();
        int totalColumns = this.dataset.getHeatMap().getColumnsCount();
        int totalRows = this.dataset.getHeatMap().getRowCount();
        int topMargin = (int)this.topMarginSize;
        int bottomMargin = (int)this.bottomMarginSize;
        int leftMargin = (int)this.leftMarginSize;
        int rightMargin = (int)this.rightMarginSize;
        int minX = (int)area.getMinX() + leftMargin;
        int minY = (int)area.getMinY() + topMargin;
        int width = (int)area.getWidth() - leftMargin - rightMargin;
        int height = (int)area.getHeight() - bottomMargin - topMargin;
        int columnTreeHeight = (int)this.columnTreeSize;
        int rowTreeWidth = (int)this.rowTreeSize;
        if (!this.rowTreeVisibility) {
            rowTreeWidth = 0;
        }
        if (!this.columnTreeVisibility) {
            columnTreeHeight = 0;
        }
        int columnNamesInitialHeight = (int)this.columnNamesSize;
        int rowNamesInitialWidth = (int)this.rowNamesSize;
        int heatMapWidth = (int)((area.getWidth() - (double)rowTreeWidth - (double)rowNamesInitialWidth) * (double)visibleColumns / (double)totalColumns);
        int heatMapHeight = (int)((area.getHeight() - (double)columnTreeHeight - (double)columnNamesInitialHeight) * (double)visibleRows / (double)totalRows);
        int columnNamesHeight = height - heatMapHeight - columnTreeHeight;
        int rowNamesWidth = width - heatMapWidth - rowTreeWidth;
        if (!this.rowNamesVisibility) {
            rowNamesWidth = 0;
        }
        if (!this.columnNamesVisibility) {
            columnNamesHeight = 0;
        }
        int maxX = minX + width;
        int maxY = minY + height;
        if (this.drawFromLeftToRight) {
            heatMapMinX = minX + rowTreeWidth;
            rowTreeLocation = RectangleEdge.LEFT;
            rowNamesLocation = RectangleEdge.RIGHT;
        } else {
            heatMapMinX = minX + rowNamesWidth;
            rowTreeLocation = RectangleEdge.RIGHT;
            rowNamesLocation = RectangleEdge.LEFT;
        }
        if (this.drawFromTopToBottom) {
            heatMapMinY = minY + columnTreeHeight;
            columnTreeLocation = RectangleEdge.TOP;
            columnNamesLocation = RectangleEdge.BOTTOM;
        } else {
            heatMapMinY = minY + columnNamesHeight;
            columnTreeLocation = RectangleEdge.BOTTOM;
            columnNamesLocation = RectangleEdge.TOP;
        }
        int heatMapMaxX = heatMapMinX + heatMapWidth;
        int heatMapMaxY = heatMapMinY + heatMapHeight;
        if (this.drawFromTopToBottom) {
            columnTreeArea = new Rectangle(heatMapMinX, minY, heatMapWidth, columnTreeHeight);
            columnNamesArea = new Rectangle(heatMapMinX, heatMapMaxY, heatMapWidth, maxY - heatMapMaxY);
        } else {
            columnTreeArea = new Rectangle(heatMapMinX, heatMapMaxY, heatMapWidth, columnTreeHeight);
            columnNamesArea = new Rectangle(heatMapMinX, minY, heatMapWidth, maxY - heatMapMaxY);
        }
        if (this.drawFromLeftToRight) {
            rowTreeArea = new Rectangle(minX, heatMapMinY, rowTreeWidth, heatMapHeight);
            rowNamesArea = new Rectangle(heatMapMaxX, heatMapMinY, maxX - heatMapMaxX, heatMapHeight);
        } else {
            rowTreeArea = new Rectangle(heatMapMaxX, heatMapMinY, rowTreeWidth, heatMapHeight);
            rowNamesArea = new Rectangle(minX, heatMapMinY, maxX - heatMapMaxX, heatMapHeight);
        }
        Rectangle heatMapArea = new Rectangle(heatMapMinX, heatMapMinY, heatMapWidth, heatMapHeight);
        double blockWidth = columnTreeArea.getWidth() / (double)visibleColumns;
        double blockHeight = rowTreeArea.getHeight() / (double)visibleRows;
        int sizeOfNodeSymbol = blockWidth < blockHeight ? (int)(3.0 + blockWidth / 5.0) : (int)(3.0 + blockHeight / 5.0);
        double getColumnTreeHeightUnitInPixels = this.dataset.getColumnClusteringTree() != null ? columnTreeArea.getHeight() / this.dataset.getColumnClusteringTree().getHeight() : 0.0;
        double getRowTreeHeightUnitInPixels = this.dataset.getRowClusteringTree() != null ? rowTreeArea.getWidth() / this.dataset.getRowClusteringTree().getHeight() : 0.0;
        HCPlotState state = new HCPlotState(info, (int)heatMapArea.getMinX(), (int)heatMapArea.getMinY(), sizeOfNodeSymbol, blockWidth, blockHeight, getColumnTreeHeightUnitInPixels, getRowTreeHeightUnitInPixels);
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(heatMapArea);
        }
        this.drawBackground(g2, area);
        this.drawHeatMap(g2, state, heatMapArea, visibleColumns, visibleRows);
        if (this.getColumnTreeVisibility() && g2.getClip().intersects(columnTreeArea)) {
            this.drawSubTree(g2, state, this.columnClusteringInfo.getRootNode(), columnTreeArea, columnTreeLocation);
        }
        if (this.getRowTreeVisibility() && g2.getClip().intersects(rowTreeArea)) {
            this.drawSubTree(g2, state, this.rowClusteringInfo.getRootNode(), rowTreeArea, rowTreeLocation);
        }
        if (this.getRowNamesVisibility()) {
            this.rowNames.draw(g2, RectangleEdge.coordinate(heatMapArea, rowNamesLocation), area, rowNamesArea, rowNamesLocation, info);
        }
        if (this.getColumnNamesVisibility()) {
            this.columnNames.draw(g2, RectangleEdge.coordinate(heatMapArea, columnNamesLocation), area, columnNamesArea, columnNamesLocation, info);
        }
        if (!this.closedRows.isEmpty()) {
            int rowcount = this.closedRows.size();
            item = null;
            color = new Color(0, 0, 0);
            for (i = 0; i < rowcount; ++i) {
                item = this.closedRows.first();
                this.closedRows.remove(item);
                r = new Rectangle(0, item, visibleColumns, 1);
                this.drawSelection(g2, state, color, r);
            }
        }
        if (!this.closedColumns.isEmpty()) {
            int columncount = this.closedColumns.size();
            item = null;
            color = new Color(0, 0, 0);
            for (i = 0; i < columncount; ++i) {
                item = this.closedColumns.first();
                this.closedColumns.remove(item);
                r = new Rectangle(item, 0, 1, visibleRows);
                this.drawSelection(g2, state, color, r);
            }
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        if (this.mouseOverHighlight && event.getEntity() != null) {
            if (event.getEntity() instanceof HeatMapBlockEntity) {
                HeatMapBlockEntity entity = (HeatMapBlockEntity)event.getEntity();
                int oldRow = this.getRowTreeHighlight();
                int oldColumn = this.getColumnTreeHighlight();
                if (oldRow != entity.getRow() || oldColumn != entity.getColumn()) {
                    this.setRowTreeHighlight(entity.getRow());
                    this.setColumnTreeHighlight(entity.getColumn());
                }
            } else if (event.getEntity() instanceof HCTreeNodeEntity) {
                // empty if block
            }
        }
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof HCTreeNodeEntity) {
            HCTreeNodeEntity entity = (HCTreeNodeEntity)event.getEntity();
            HCTreeNodeInfo node = entity.getHCTreeNodeInfo();
            boolean shift = event.getTrigger().isShiftDown();
            if (shift) {
                node.setSubTreeOpen(!node.isNodeOpen());
            } else {
                node.setNodeOpen(!node.isNodeOpen());
            }
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof HCTreeNodeInfo) {
            HCTreeNodeInfo info = (HCTreeNodeInfo)event.getSource();
            this.notifyListeners(new ClusteringTreeChangeEvent(this, info));
        }
    }

    public HCToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(HCToolTipGenerator toolTipGenerator) {
        this.toolTipGenerator = toolTipGenerator;
    }

    public JPanel getOptionsPanel() {
        return this.optionsEditor.getPanel();
    }

    public JPanel getPalettePanel() {
        return this.paletteEditor.getPanel();
    }

    public String getOptionsPanelName() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.viski_bundle.LocalizationBundle");
        return lr.getString("HC_options_panel");
    }

    public String getPalettePanelName() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.viski_bundle.LocalizationBundle");
        return lr.getString("HC_palette_panel");
    }

    public void showSelection(Selection[] detailedSelection, boolean isRowSelection) {
        this.selected = detailedSelection;
        this.isRowSelection = isRowSelection;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    static {
        ChartEditorManager.setChartEditorFactory(new ViskiChartEditorFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Selection {
        NO,
        PARTIAL,
        YES;

    }
}

