/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;

public class JMSSink
implements MessageListener {
    static Logger logger = Logger.getLogger(class$org$apache$log4j$net$JMSSink == null ? (class$org$apache$log4j$net$JMSSink = JMSSink.class$("org.apache.log4j.net.JMSSink")) : class$org$apache$log4j$net$JMSSink);
    static /* synthetic */ Class class$org$apache$log4j$net$JMSSink;

    public static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray.length != 5) {
            JMSSink.usage("Wrong number of arguments.");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        String string6 = stringArray[4];
        if (string6.endsWith(".xml")) {
            new DOMConfigurator();
            DOMConfigurator.configure(string6);
        } else {
            new PropertyConfigurator();
            PropertyConfigurator.configure(string6);
        }
        new JMSSink(string2, string3, string4, string5);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Type \"exit\" to quit JMSSink.");
        while (!(string = bufferedReader.readLine()).equalsIgnoreCase("exit")) {
        }
        System.out.println("Exiting. Kill the application if it does not exit due to daemon threads.");
    }

    public JMSSink(String string, String string2, String string3, String string4) {
        try {
            InitialContext initialContext = new InitialContext();
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)JMSSink.lookup(initialContext, string);
            TopicConnection topicConnection = topicConnectionFactory.createTopicConnection(string3, string4);
            topicConnection.start();
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            Topic topic = (Topic)initialContext.lookup(string2);
            TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
            topicSubscriber.setMessageListener(this);
        }
        catch (Exception exception) {
            logger.error("Could not read JMS message.", exception);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                LoggingEvent loggingEvent = (LoggingEvent)objectMessage.getObject();
                Logger logger = Logger.getLogger(loggingEvent.getLoggerName());
                logger.callAppenders(loggingEvent);
            } else {
                logger.warn("Received message is of type " + message.getJMSType() + ", was expecting ObjectMessage.");
            }
        }
        catch (JMSException jMSException) {
            logger.error("Exception thrown while processing incoming message.", jMSException);
        }
    }

    protected static Object lookup(Context context, String string) throws NamingException {
        try {
            return context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            logger.error("Could not find name [" + string + "].");
            throw nameNotFoundException;
        }
    }

    static void usage(String string) {
        System.err.println(string);
        System.err.println("Usage: java " + (class$org$apache$log4j$net$JMSSink == null ? (class$org$apache$log4j$net$JMSSink = JMSSink.class$("org.apache.log4j.net.JMSSink")) : class$org$apache$log4j$net$JMSSink).getName() + " TopicConnectionFactoryBindingName TopicBindingName username password configFile");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

