/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.PayloadMessage;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobMessage
extends PayloadMessage {
    private static final Logger logger = Logger.getLogger(JobMessage.class);
    private static final String KEY_JOB_ID = "jobID";
    private static final String KEY_ANALYSIS_ID = "analysisID";
    private String analysisId;
    private String jobId;

    public JobMessage() {
    }

    public JobMessage(String jobId, String analysisId, List<String> parameters) {
        super(parameters);
        this.jobId = jobId;
        this.analysisId = analysisId;
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.jobId = from.getString(KEY_JOB_ID);
        this.analysisId = from.getString(KEY_ANALYSIS_ID);
        logger.debug("Unmarshalled jobID : " + this.jobId);
        logger.debug("Unmarshalled analysisID : " + this.analysisId);
    }

    @Override
    public void marshal(MapMessage mapMessage) throws JMSException {
        super.marshal(mapMessage);
        logger.debug("Marshalling: jobID : " + this.jobId);
        logger.debug("Marshalling: analysisID : " + this.analysisId);
        mapMessage.setString(KEY_JOB_ID, this.jobId);
        mapMessage.setString(KEY_ANALYSIS_ID, this.analysisId);
    }

    public String getAnalysisId() {
        return this.analysisId;
    }

    public void setAnalysisId(String id) {
        this.analysisId = id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }
}

