/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.RestServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;

public class JettyFileServer {
    private Server jettyInstance;
    private AuthorisedUrlRepository urlRepository;

    public JettyFileServer(AuthorisedUrlRepository urlRepository) {
        this.urlRepository = urlRepository;
    }

    public void start(String resourceBase, int port) throws Exception {
        if (DirectoryLayout.getInstance().getConfiguration().getBoolean("filebroker", "jetty-debug")) {
            System.setProperty("DEBUG", "true");
        }
        this.jettyInstance = new Server();
        this.jettyInstance.setThreadPool(new QueuedThreadPool());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setServer(this.jettyInstance);
        connector.setPort(port);
        this.jettyInstance.setConnectors(new Connector[]{connector});
        Context root = new Context(this.jettyInstance, "/", false, false);
        root.setResourceBase(resourceBase);
        root.addServlet(new ServletHolder(new RestServlet(this.urlRepository, this.urlRepository.getRootUrl())), "/*");
        this.jettyInstance.start();
    }

    public boolean isRunning() {
        return this.jettyInstance.isRunning();
    }
}

