/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.description.GenericInputTypes;
import fi.csc.microarray.description.ParsedVVSADL;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.AdvancedStringTokenizer;
import fi.csc.microarray.util.Deseparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VVSADLParser {
    private static final Logger logger = Logger.getLogger(VVSADLParser.class);
    private String unitName;
    private HashMap<String, VVSADLSyntax.InputType> inputTypeMap = new HashMap();

    public static String generateOperationIdentifier(String category, String name) {
        return "\"" + category + "\"/\"" + name + "\"";
    }

    public VVSADLParser() {
        this(null);
    }

    public VVSADLParser(String filename) {
        this.unitName = filename;
        this.addInputType(GenericInputTypes.GENERIC);
    }

    public ParsedVVSADL parse(String vvsadlString) throws ParseException {
        AdvancedStringTokenizer tokens = this.getTokenizer(vvsadlString);
        return this.parseAnalysis(tokens);
    }

    public List<ParsedVVSADL> parseMultiple(String vvsadlString) throws ParseException {
        LinkedList<ParsedVVSADL> descriptions = new LinkedList<ParsedVVSADL>();
        AdvancedStringTokenizer tokens = this.getTokenizer(vvsadlString);
        boolean parsingPreviousSuccessful = true;
        while (tokens.hasNext()) {
            try {
                descriptions.add(this.parseAnalysis(tokens));
                parsingPreviousSuccessful = true;
            }
            catch (ParseException pe) {
                if (parsingPreviousSuccessful) {
                    descriptions.removeLast();
                    logger.error("Could not parse description. ", pe);
                }
                parsingPreviousSuccessful = false;
            }
        }
        return descriptions;
    }

    public void addInputType(VVSADLSyntax.InputType type) {
        this.inputTypeMap.put(type.getName(), type);
    }

    private ParsedVVSADL parseAnalysis(AdvancedStringTokenizer tokens) throws ParseException {
        List<String> outputs;
        List<ParsedVVSADL.Input> inputs;
        if (!"ANALYSIS".equals(tokens.next())) {
            throw new ParseException("VVSADL should start with \"ANALYSIS\", not " + tokens.current(), this.unitName);
        }
        String packageName = tokens.next();
        String name = tokens.next();
        if (this.unitName == null) {
            this.unitName = packageName + " / " + name;
        }
        String comment = this.readComment(tokens);
        ParsedVVSADL description = new ParsedVVSADL(name, packageName, comment);
        if (tokens.hasNext() && "INPUT".equals(tokens.peek())) {
            tokens.next();
            inputs = this.parseInputs(tokens, description);
            description.addInputs(inputs);
        }
        if (tokens.hasNext() && "METAINPUT".equals(tokens.peek())) {
            tokens.next();
            inputs = this.parseInputs(tokens, description);
            description.addMetaInputs(inputs);
        }
        if (tokens.hasNext() && "OUTPUT".equals(tokens.peek())) {
            tokens.next();
            outputs = this.parseOutputs(tokens, description);
            description.addOutputs(outputs);
        }
        if (tokens.hasNext() && "METAOUTPUT".equals(tokens.peek())) {
            tokens.next();
            outputs = this.parseOutputs(tokens, description);
            description.addMetaOutputs(outputs);
        }
        while (tokens.hasNext() && "PARAMETER".equals(tokens.peek())) {
            ParsedVVSADL.Parameter parameter = this.parseParameter(tokens);
            description.addParameter(parameter);
        }
        return description;
    }

    private List<String> parseOutputs(AdvancedStringTokenizer tokens, ParsedVVSADL description) {
        LinkedList<String> outputList = new LinkedList<String>();
        Deseparator outputs = new Deseparator(",", tokens, 1);
        for (String[] output : outputs) {
            outputList.add(output[0]);
        }
        return outputList;
    }

    private List<ParsedVVSADL.Input> parseInputs(AdvancedStringTokenizer tokens, ParsedVVSADL description) {
        LinkedList<ParsedVVSADL.Input> inputList = new LinkedList<ParsedVVSADL.Input>();
        Deseparator inputs = new Deseparator(",", tokens, 2);
        for (String[] input : inputs) {
            ParsedVVSADL.Input newInput;
            if (input[1].contains("[...]")) {
                String filePattern = input[1];
                String prefix = filePattern.substring(0, filePattern.indexOf("[...]"));
                String postfix = filePattern.substring(filePattern.indexOf("[...]") + "[...]".length());
                newInput = ParsedVVSADL.Input.createInputSet(this.inputTypeMap.get(input[0]), prefix, postfix);
            } else {
                newInput = ParsedVVSADL.Input.createInput(this.inputTypeMap.get(input[0]), input[1]);
            }
            inputList.add(newInput);
        }
        return inputList;
    }

    private ParsedVVSADL.Parameter parseParameter(AdvancedStringTokenizer tokens) throws ParseException {
        if (!"PARAMETER".equals(tokens.next())) {
            throw new ParseException("VVSADL param line should start with \"PARAMETER\", not " + tokens.current(), this.unitName);
        }
        String name = tokens.next();
        VVSADLSyntax.ParameterType type = null;
        String[] options = null;
        if (tokens.peek().startsWith("[")) {
            options = this.readSelectionType(tokens);
            type = VVSADLSyntax.ParameterType.ENUM;
        } else {
            type = VVSADLSyntax.ParameterType.valueOf(tokens.next());
        }
        String from = null;
        String to = null;
        String defaultValue = null;
        if ("FROM".equals(tokens.peek())) {
            tokens.next();
            from = tokens.next();
        }
        if ("TO".equals(tokens.peek())) {
            tokens.next();
            to = tokens.next();
        }
        if ("DEFAULT".equals(tokens.peek())) {
            tokens.next();
            defaultValue = tokens.next();
        }
        String comment = this.readComment(tokens);
        ParsedVVSADL.Parameter parameter = new ParsedVVSADL.Parameter(name, type, options, from, to, defaultValue, comment);
        return parameter;
    }

    private String readComment(AdvancedStringTokenizer tokens) throws ParseException {
        String comment = null;
        try {
            comment = tokens.next().substring(1);
            if (comment.contains(")")) {
                return "";
            }
            while (tokens.hasNext() && !tokens.peek().contains(")")) {
                comment = comment + " " + tokens.next();
            }
            String lastToken = tokens.next();
            comment = comment + " " + lastToken.substring(0, lastToken.length() - 1);
            return comment;
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("on exception comment was: " + comment);
            throw new ParseException("comment start or end missing", this.unitName);
        }
    }

    private String[] readSelectionType(AdvancedStringTokenizer tokens) {
        String s = "";
        while (!(s = s + tokens.next()).endsWith("]")) {
        }
        s = s.substring(1, s.length() - 1);
        AdvancedStringTokenizer options = new AdvancedStringTokenizer(s, true, false, ",");
        LinkedList<String> list = new LinkedList<String>();
        while (options.hasNext()) {
            list.add(options.next());
        }
        return list.toArray(new String[0]);
    }

    private AdvancedStringTokenizer getTokenizer(String vvsadlString) {
        return new AdvancedStringTokenizer(vvsadlString, false, true, " \t\n\r\f/");
    }

    public static class ParseException
    extends MicroarrayException {
        public ParseException(String msg, String filename) {
            super(msg + (filename != null ? " (in " + filename + ")" : ""));
        }
    }
}

