/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldFSSnapshottingSession {
    private static final String METADATA_FILENAME = "snapshot_metadata.txt";
    private static final String ROOT_FOLDER_ID = "0";
    private FSDataManager manager;
    private HashMap<Integer, DataItem> idMap = new HashMap();
    private HashMap<DataItem, Integer> reversedIdMap = new HashMap();

    public OldFSSnapshottingSession(FSDataManager manager) {
        this.manager = manager;
    }

    private File getMetadataFile(File snapshotDir) {
        File metadataFile = new File(snapshotDir.getPath() + File.separator + METADATA_FILENAME);
        return metadataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataItem> loadFromSnapshot(File snapshotDirectory, DataFolder parentFolder) throws IOException, MicroarrayException {
        File metadataFile = this.getMetadataFile(snapshotDirectory);
        LinkedList<DataItem> newItems = new LinkedList<DataItem>();
        BufferedReader metadataIn = null;
        try {
            metadataIn = new BufferedReader(new FileReader(metadataFile));
            String line = metadataIn.readLine();
            while (line != null) {
                DataBean bean;
                String id;
                String[] split;
                if (line.startsWith("DATAFOLDER ")) {
                    split = line.split(" ");
                    id = split[1];
                    DataFolder folder = this.manager.createFolder("");
                    newItems.add(folder);
                    this.mapId(id, folder);
                } else if (line.startsWith("DATABEAN ")) {
                    split = line.split(" ");
                    id = split[1];
                    File contentFile = new File(snapshotDirectory.getAbsolutePath() + File.separator + split[2]);
                    FSDataBean bean2 = this.manager.createDataBean("<empty>", new FileInputStream(contentFile));
                    Operation importOperation = new Operation(OperationDefinition.IMPORT_DEFINITION, new DataBean[]{bean2});
                    bean2.setOperation(importOperation);
                    bean2.setContentType(this.manager.guessContentType(contentFile));
                    newItems.add(bean2);
                    this.mapId(id, bean2);
                } else if (line.startsWith("NAME ")) {
                    split = line.split(" ");
                    id = split[1];
                    String name = OldFSSnapshottingSession.afterNthSpace(line, 2);
                    DataItem item = this.fetchItem(id);
                    item.setName(name);
                    if (item instanceof DataBean) {
                        DataBean bean3 = (DataBean)item;
                        bean3.setContentType(this.manager.guessContentType(name));
                    }
                } else if (line.startsWith("OPERATION ")) {
                    split = line.split(" ");
                    id = split[1];
                    bean = (DataBean)this.fetchItem(id);
                    String[] opName = OldFSSnapshottingSession.afterNthSpace(line, 2).split("/");
                    OperationDefinition od = new OperationDefinition(opName[1], new OperationCategory(opName[0]), "", false);
                    Operation op = new Operation(od, new DataBean[]{bean});
                    bean.setOperation(op);
                } else if (line.startsWith("OPERATION_COLOR ")) {
                    split = line.split(" ");
                    id = split[1];
                    bean = (DataBean)this.fetchItem(id);
                    int color = Integer.parseInt(split[2]);
                    bean.getOperation().getDefinition().getCategory().setColor(new Color(color));
                } else if (line.startsWith("CHILD ")) {
                    split = line.split(" ");
                    String childId = split[1];
                    String parentId = split[2];
                    DataFolder parent = parentId.equals(ROOT_FOLDER_ID) ? this.manager.getRootFolder() : (DataFolder)this.fetchItem(parentId);
                    DataItem child = this.fetchItem(childId);
                    parent.addChild(child);
                } else if (line.startsWith("NOTES ")) {
                    split = line.split(" ");
                    id = split[1];
                    String notes = OldFSSnapshottingSession.afterNthSpace(line, 2);
                    DataBean item = (DataBean)this.fetchItem(id);
                    item.setNotes(notes);
                } else if (line.startsWith("LINK ")) {
                    split = line.split(" ");
                    DataBean.Link link = DataBean.Link.valueOf(split[1]);
                    String fromId = split[2];
                    String toId = split[3];
                    DataBean from = (DataBean)this.fetchItem(fromId);
                    DataBean to = (DataBean)this.fetchItem(toId);
                    from.addLink(link, to);
                } else {
                    throw new RuntimeException("metadata error in " + metadataFile.getCanonicalPath() + ": line could not be processed \"" + line + "\"");
                }
                line = metadataIn.readLine();
            }
        }
        finally {
            if (metadataIn != null) {
                metadataIn.close();
            }
        }
        return newItems;
    }

    private static String afterNthSpace(String line, int nth) {
        int from = 0;
        for (int i = 0; i < nth; ++i) {
            from = line.indexOf(" ", from + 1);
        }
        return line.substring(from + 1);
    }

    private void mapId(String id, DataItem item) {
        Integer iid = Integer.parseInt(id);
        this.idMap.put(iid, item);
        this.reversedIdMap.put(item, iid);
    }

    private DataItem fetchItem(String id) {
        Integer iid = Integer.parseInt(id);
        return this.idMap.get(iid);
    }
}

