/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataBeanBase;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataManagerBase;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.databeans.fs.FSDataFolder;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDataBean
extends DataBeanBase {
    private ContentType contentType;
    private String name;
    private Operation sourceOperation;
    private Date date;
    private String notes;
    private DataFolder parentFolder;
    private LinkedList<LinkedBean> outgoingLinks = new LinkedList();
    private LinkedList<LinkedBean> incomingLinks = new LinkedList();
    private File contentFile;

    public FSDataBean(String name, ContentType contentType, Date date, DataBean[] sources, DataFolder parentFolder, DataManagerBase manager, File contentFile) {
        super(manager);
        this.name = name;
        this.date = date;
        this.parentFolder = parentFolder;
        if (parentFolder != null) {
            parentFolder.addChild(this);
        }
        for (DataBean source : sources) {
            source.addLink(DataBean.Link.DERIVATION, this);
        }
        this.contentFile = contentFile;
        this.contentType = contentType;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void removeLink(DataBean.Link type, DataBean target) {
        for (LinkedBean outgoingLink : this.outgoingLinks) {
            if (outgoingLink.bean != target || outgoingLink.link != type) continue;
            this.outgoingLinks.remove(outgoingLink);
            FSDataBean fsBean = (FSDataBean)outgoingLink.bean;
            for (LinkedBean incomingLink : fsBean.incomingLinks) {
                if (incomingLink.bean != this || incomingLink.link != type) continue;
                fsBean.incomingLinks.remove(incomingLink);
                LinksChangedEvent lce = new LinksChangedEvent(this, target, type, false);
                this.dataManager.dispatchEventIfVisible(lce);
                return;
            }
        }
        throw new RuntimeException("internal error: failed locate links for: " + this.getName() + " <" + (Object)((Object)type) + "> " + target.getName());
    }

    @Override
    public DataFolder getParent() {
        return this.parentFolder;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
        ContentChangedEvent cce = new ContentChangedEvent(this);
        this.dataManager.dispatchEventIfVisible(cce);
    }

    @Override
    public void addLink(DataBean.Link type, DataBean target) {
        if (target == null) {
            return;
        }
        ((FSDataBean)target).incomingLinks.add(new LinkedBean(type, this));
        this.outgoingLinks.add(new LinkedBean(type, target));
        if (this.getParent() != null && target.getParent() != null) {
            LinksChangedEvent lce = new LinksChangedEvent(this, target, type, true);
            this.dataManager.dispatchEvent(lce);
        }
    }

    @Override
    public List<DataBean> getLinkTargets(DataBean.Link ... types) {
        return this.getLinkedBeans(types, this.outgoingLinks);
    }

    @Override
    public List<DataBean> getLinkSources(DataBean.Link ... types) {
        return this.getLinkedBeans(types, this.incomingLinks);
    }

    private List<DataBean> getLinkedBeans(DataBean.Link[] types, LinkedList<LinkedBean> links) {
        LinkedList<DataBean> targets = new LinkedList<DataBean>();
        block0: for (LinkedBean linkTarget : links) {
            for (DataBean.Link type : types) {
                if (linkTarget.link != type) continue;
                targets.add(linkTarget.bean);
                continue block0;
            }
        }
        return targets;
    }

    @Override
    public Operation getOperation() {
        return this.sourceOperation;
    }

    @Override
    public void setOperation(Operation operation) {
        this.sourceOperation = operation;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public InputStream getRawContentByteStream() throws MicroarrayException {
        FileInputStream is;
        try {
            is = new FileInputStream(this.contentFile);
        }
        catch (FileNotFoundException e) {
            throw new MicroarrayException(e);
        }
        return is;
    }

    @Override
    public byte[] getContents() throws MicroarrayException {
        try {
            return Files.inputStreamToBytes(this.getContentByteStream());
        }
        catch (IOException e) {
            throw new MicroarrayException(e);
        }
    }

    @Override
    public OutputStream getContentOutputStreamAndLockDataBean() throws MicroarrayException, IOException {
        FileOutputStream os;
        this.lockContent();
        this.setContentChanged(true);
        this.streamStartCache = null;
        this.resetContentCache();
        try {
            os = new FileOutputStream(this.contentFile);
        }
        catch (FileNotFoundException e) {
            throw new MicroarrayException(e);
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContentOutputStreamAndUnlockDataBean(OutputStream out) throws MicroarrayException, IOException {
        try {
            out.close();
        }
        finally {
            this.unlockContent();
        }
        ContentChangedEvent cce = new ContentChangedEvent(this);
        this.dataManager.dispatchEventIfVisible(cce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this.lockContent();
        try {
            this.contentFile.delete();
            this.contentFile = null;
            this.contentType = null;
        }
        finally {
            this.unlockContent();
        }
    }

    @Override
    public long getContentLength() {
        return this.contentFile.length();
    }

    public File getContentFile() {
        return this.contentFile;
    }

    public void setParent(FSDataFolder dataFolder) {
        this.parentFolder = dataFolder;
    }

    private static class LinkedBean {
        DataBean.Link link;
        DataBean bean;

        LinkedBean(DataBean.Link link, DataBean bean) {
            this.link = link;
            this.bean = bean;
        }
    }
}

