/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features.bio;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.BasicFeature;
import fi.csc.microarray.databeans.features.CalculatingIterable;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProvider;
import fi.csc.microarray.databeans.features.FeatureProviderBase;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.exception.MicroarrayException;

public class NormalisedExpressionProvider
extends FeatureProviderBase {
    public Feature createFeature(String postfix, DataBean bean) {
        return new NormalisedExpression(bean, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NormalisedExpression
    extends BasicFeature {
        private static final String EXPRESSION_COLUMN = "/column/chip.microarray1.cel";
        private static final String RED_CHANNEL_INTENSITY = "/column/sample";
        private static final String RED_CHANNEL_BACKGROUND = "/column/samplebg";
        private static final String GREEN_CHANNEL_INTENSITY = "/column/control";
        private static final String GREEN_CHANNEL_BACKGROUND = "/column/controlbg";
        private static final String AFFY_INTENSITY = "/column/MEAN";

        public NormalisedExpression(DataBean bean, FeatureProvider factory) {
            super(bean, factory);
        }

        @Override
        public Iterable<Float> asFloats() throws MicroarrayException {
            if (this.getDataBean().queryFeatures(EXPRESSION_COLUMN).exists()) {
                return this.getDataBean().queryFeatures(EXPRESSION_COLUMN).asFloats();
            }
            QueryResult rciColumn = this.getDataBean().queryFeatures(RED_CHANNEL_INTENSITY);
            QueryResult rcbColumn = this.getDataBean().queryFeatures(RED_CHANNEL_BACKGROUND);
            QueryResult gciColumn = this.getDataBean().queryFeatures(GREEN_CHANNEL_INTENSITY);
            QueryResult gcbColumn = this.getDataBean().queryFeatures(GREEN_CHANNEL_BACKGROUND);
            if (rciColumn.exists() && rcbColumn.exists() && gciColumn.exists() && gcbColumn.exists()) {
                CalculatingIterable redIntensity = new CalculatingIterable(rciColumn.asFloats(), rcbColumn.asFloats(), CalculatingIterable.CalcOperation.SUBTRACT);
                CalculatingIterable greenIntensity = new CalculatingIterable(gciColumn.asFloats(), gcbColumn.asFloats(), CalculatingIterable.CalcOperation.SUBTRACT);
                return new CalculatingIterable(redIntensity, greenIntensity, CalculatingIterable.CalcOperation.SUBTRACT);
            }
            if (this.getDataBean().queryFeatures(AFFY_INTENSITY).exists()) {
                return this.getDataBean().queryFeatures(AFFY_INTENSITY).asFloats();
            }
            return null;
        }
    }
}

