/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.DataModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class ColorScalePanel
extends JPanel {
    DataModel dataModel;
    float[] scaleValues;

    public ColorScalePanel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.scaleValues = dataModel.getColorScaleValues();
        this.setSize(60, 300);
        this.setPreferredSize(new Dimension(60, 300));
        this.setBackground(Color.BLACK);
        this.setOpaque(true);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        float upperLimit = (float)g.getClipBounds().getHeight() - 20.0f;
        int y = 0;
        while ((float)y < upperLimit) {
            g.setColor(this.dataModel.getColorModel().getColorFor((float)y / upperLimit));
            g.drawLine(10, 10 + y, 20, 10 + y);
            ++y;
        }
        for (float value : this.scaleValues) {
            int y2 = (int)((value - this.scaleValues[0]) / (this.scaleValues[this.scaleValues.length - 1] - this.scaleValues[0]) * upperLimit - 1.0f);
            if (value == this.scaleValues[0]) {
                y2 = 0;
            }
            g.setColor(Color.WHITE);
            int[] xPoints = new int[]{21, 26, 26};
            int[] yPoints = new int[]{10 + y2, 7 + y2, 13 + y2};
            g.fillPolygon(xPoints, yPoints, 3);
            g.drawString("" + value, 30, y2 + 15);
        }
    }
}

