/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TsvToConstant {
    public static void main(String[] args) {
        int[] fieldLengths = new int[]{32, 64, 8, 8, 8, 8, 16, 16, 2};
        System.out.println("File converting started");
        Long startTime = System.currentTimeMillis();
        File in = new File("sorted.txt");
        File out = new File("constant.fsf");
        try {
            String line;
            BufferedWriter writer = new BufferedWriter(new FileWriter(out));
            BufferedReader reader = new BufferedReader(new FileReader(in));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] cols = line.split("\t");
                StringBuilder constLine = new StringBuilder();
                for (int j = 0; j < fieldLengths.length; ++j) {
                    constLine.append(TsvToConstant.fillWithSpaces(cols[j], fieldLengths[j]));
                }
                constLine.append("\n");
                writer.write(constLine.toString());
                if (i % 10000 == 0) {
                    System.out.println("" + (int)((float)(line.length() * i) / (float)in.length() * 100.0f) + " % ");
                }
                ++i;
            }
            writer.flush();
            writer.close();
            reader.close();
            System.out.println("DONE in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String fillWithSpaces(String orig, int length) {
        String spaces = "                                                                                 ";
        return orig + spaces.substring(0, length - orig.length());
    }
}

