/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqTrack
extends Track {
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();
    private Color[] charColors = new Color[]{new Color(64, 192, 64, 128), new Color(64, 64, 192, 128), new Color(128, 128, 128, 128), new Color(192, 64, 64, 128)};
    private long maxBpLength;

    public SeqTrack(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions, long maxBpLength) {
        super(view, file, handler, readInstructions);
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.reads != null) {
            Iterator<RegionContent> iter = this.reads.iterator();
            while (iter.hasNext()) {
                RegionContent read = iter.next();
                if (!read.region.intercepts(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                long startBp = read.region.start;
                long endBp = read.region.end;
                String seq = (String)read.values.get((Object)Content.SEQUENCE);
                seq = seq != null ? seq.trim().toUpperCase() : "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA".substring(0, (int)(endBp - startBp + 1L));
                drawables.addAll(this.getSeqDrawables(startBp, endBp, seq, 1));
                drawables.addAll(this.getSeqDrawables(startBp, endBp, this.complement(seq), 11));
            }
        }
        return drawables;
    }

    private String complement(String seq) {
        StringBuffer buf = new StringBuffer(seq);
        block6: for (int j = 0; j < seq.length(); ++j) {
            switch (buf.charAt(j)) {
                case 'A': {
                    buf.setCharAt(j, 'T');
                    continue block6;
                }
                case 'C': {
                    buf.setCharAt(j, 'G');
                    continue block6;
                }
                case 'G': {
                    buf.setCharAt(j, 'C');
                    continue block6;
                }
                case 'T': {
                    buf.setCharAt(j, 'A');
                }
            }
        }
        return buf.toString();
    }

    private Collection<Drawable> getSeqDrawables(long startBb, long endBp, String seq, int yOffset) {
        Rectangle rect = new Rectangle();
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        rect.x = this.getView().bpToTrack(startBb);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        rect.y = 1 + yOffset;
        rect.height = 10;
        int CHAR_WIDTH = 7;
        float x = rect.x;
        float increment = (float)rect.width / (float)seq.length();
        for (int j = 0; j < seq.length(); ++j) {
            char letter = seq.charAt(j);
            if (rect.width > seq.length() * 7) {
                drawables.add(new TextDrawable((int)x, rect.y + 8, "" + letter, Color.black));
            }
            Color bg = Color.white;
            if (letter == 'A') {
                bg = this.charColors[0];
            } else if (letter == 'C') {
                bg = this.charColors[1];
            } else if (letter == 'G') {
                bg = this.charColors[2];
            } else if (letter == 'T') {
                bg = this.charColors[3];
            }
            drawables.add(new RectDrawable((int)x, rect.y - 2, (int)increment, 10, bg, null));
            x += increment;
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult<RegionContent> areaResult) {
        this.reads.add((RegionContent)areaResult.content);
        this.getView().redraw();
    }

    @Override
    public int getMaxHeight() {
        if (this.getView().getBpRegion().getLength() <= this.maxBpLength) {
            return 21;
        }
        return 0;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(Content.SEQUENCE);
    }

    @Override
    public boolean isConcised() {
        return false;
    }
}

