/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.TsvChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StraightforwardFileParser<T>
extends AreaRequestHandler {
    private ReadInstructions<?> instructions;
    private File file;
    private ByteChunk chunk;

    public StraightforwardFileParser(File file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener, ReadInstructions<?> instructions) {
        super(areaRequestQueue, areaResultListener);
        this.instructions = instructions;
        this.file = file;
    }

    private void readFile() {
        this.chunk = new ByteChunk(this.instructions.chunker.getChunkByteLength());
        try {
            FileInputStream stream = new FileInputStream(this.file);
            this.chunk.content = new byte[(int)this.file.length()];
            stream.read(this.chunk.content);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        if (this.chunk == null) {
            this.readFile();
        }
        ChunkParser parser = this.instructions.getParser();
        parser.setChunk(this.chunk);
        while (((TsvChunkParser)parser).readNextLine()) {
            List<Object> read = parser.getRead(-1L);
            Region readReg = new Region((Long)read.get(this.instructions.fileDef.indexOf(Content.BP_START)), (Long)read.get(this.instructions.fileDef.indexOf(Content.BP_END)));
            Map<Content, Object> values = parser.getValues(-1L, areaRequest.requestedContents);
            if (!"chr1".equals((String)read.get(this.instructions.fileDef.indexOf(Content.CHROMOSOME))) || !areaRequest.intercepts(readReg)) continue;
            this.createAreaResult(new AreaResult<RegionContent>(areaRequest.status, new RegionContent(readReg, values)));
        }
    }
}

