/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.GenomeBrowser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class VerticalView
extends View {
    public VerticalView(GenomeBrowser parent, boolean movable, boolean zoomable, boolean selectable) {
        super(parent, movable, zoomable, selectable);
    }

    protected void drawView(Graphics2D g, boolean isAnimation) {
        super.drawView(g, isAnimation);
        if (this.highlight != null) {
            g.setPaint(new Color(0, 0, 0, 64));
            Rectangle rect = g.getClip().getBounds();
            rect.y = this.bpToTrack(this.highlight.start);
            rect.height = this.bpToTrack(this.highlight.end) - rect.y;
            g.fill(rect);
        }
    }

    protected void drawDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        int tmp = x;
        y = x;
        x = tmp;
        g.setPaint(drawable.color);
        if (drawable instanceof TextDrawable) {
            TextDrawable text = (TextDrawable)drawable;
            g.drawString(text.text, text.y + y + 10, text.x + x);
        } else if (drawable instanceof RectDrawable) {
            RectDrawable rect = (RectDrawable)drawable;
            if (rect.lineColor != null) {
                g.setPaint(rect.lineColor);
                g.fillRect(rect.y + y, rect.x + x, rect.height, rect.width);
            }
            g.setPaint(drawable.color);
            g.drawRect(rect.y + y, rect.x + x, rect.height, rect.width);
        } else if (drawable instanceof LineDrawable) {
            LineDrawable line = (LineDrawable)drawable;
            g.drawLine(line.y + y, line.x + x, line.y2 + y, line.x2 + x);
        }
    }

    protected void handleDrag(Point2D start, Point2D end, boolean disableDrawing) {
        long bpMove = this.trackToBp((long)start.getY()) - this.trackToBp((long)end.getY());
        if (bpMove < 0L && this.bpRegion.start < Math.abs(bpMove)) {
            bpMove = -this.bpRegion.start.longValue();
        }
        this.bpRegion.move(bpMove);
        this.setBpRegion(this.bpRegion, disableDrawing);
        this.parentPlot.redraw();
    }

    public float getTrackHeight() {
        return (float)this.getHeight() / (float)this.tracks.size();
    }

    public int getWidth() {
        return super.getHeight();
    }

    public int getHeight() {
        return super.getWidth();
    }

    public int getX() {
        return super.getY();
    }
}

