/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.visualisation.methods.VennDiagram;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.util.ObjectUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VenndiPlot
extends Plot
implements ChartMouseListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Font descriptionFont;
    private VennDataset dataset;
    private Area[] areas = new Area[7];
    private Set<Area> selected = new HashSet<Area>();
    private VennDiagram visualisation;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public VenndiPlot(String[][] idTable, List<DataBean> datas, Map<DataBean, Map<String, Integer>> indexMaps, VennDiagram parent) throws NullPointerException {
        this.dataset = new VennDataset(idTable, datas, indexMaps);
        this.visualisation = parent;
        this.updateAreas(new Rectangle(), null);
    }

    public List<String> getSelected() {
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (int i = 0; i < this.areas.length; ++i) {
            if (!this.selected.contains(this.areas[i])) continue;
            selectedIds.addAll(this.dataset.getIdentifiers(AREAS.values()[i]));
        }
        return selectedIds;
    }

    public void setSelected(Collection<String> selectedIds) {
        this.selected.clear();
        if (selectedIds != null) {
            for (AREAS area : AREAS.values()) {
                if (!selectedIds.containsAll(this.dataset.getIdentifiers(area)) || this.dataset.getCount(area) <= 0) continue;
                this.selected.add(this.areas[area.ordinal()]);
            }
        }
    }

    public VennDataset getDataset() {
        return this.dataset;
    }

    @Override
    public String getPlotType() {
        return "VennDiagram";
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        this.getInsets().trim(area);
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.drawBackground(g2, area);
        this.drawOutline(g2, area);
        Shape savedClip = g2.getClip();
        g2.clip(area);
        this.drawVenn(g2, area, info);
        g2.setClip(savedClip);
        this.drawOutline(g2, area);
    }

    private void drawVenn(Graphics2D g2, Rectangle2D area, PlotRenderingInfo info) {
        this.updateAreas(area, info);
        Color[] colors = new Color[]{VisualConstants.CATEGORY_COLORS[4], VisualConstants.CATEGORY_COLORS[5], VisualConstants.CATEGORY_COLORS[7], new Color(222, 98, 39), new Color(115, 127, 107), new Color(107, 88, 117), VisualConstants.CATEGORY_COLORS[10]};
        g2.setFont(g2.getFont().deriveFont(g2.getFont().getSize2D() * 0.8f));
        for (int i = 0; i < this.areas.length; ++i) {
            Color c;
            Area shape = this.areas[i];
            if (shape == null) continue;
            if (this.selected.contains(shape)) {
                c = new Color(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue(), 200);
                g2.setPaint(c);
                g2.fill(shape);
                g2.setPaint(Color.black);
                g2.setStroke(new BasicStroke(3.0f));
                g2.draw(shape);
                g2.setFont(g2.getFont().deriveFont(1));
            } else {
                c = new Color(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue(), 255);
                g2.setPaint(c);
                g2.fill(shape);
                g2.setPaint(Color.black);
                g2.setStroke(new BasicStroke(1.0f));
                g2.draw(shape);
                g2.setFont(g2.getFont().deriveFont(0));
            }
            g2.setPaint(Color.black);
            String str = "" + this.dataset.getCount(AREAS.values()[i]);
            int x = (int)shape.getBounds().getCenterX() - SwingUtilities.computeStringWidth(g2.getFontMetrics(), str) / 2;
            int y = (int)shape.getBounds().getCenterY() + g2.getFontMetrics().getHeight() / 2;
            g2.drawString(str, x, y);
            str = this.dataset.getDatasetName(AREAS.values()[i]);
            x = (int)shape.getBounds().getCenterX() - SwingUtilities.computeStringWidth(g2.getFontMetrics(), str) / 2;
            g2.drawString(str, x, y += g2.getFontMetrics().getHeight());
        }
    }

    private void updateAreas(Rectangle2D area, PlotRenderingInfo info) {
        double r = area.getHeight() < area.getWidth() ? (double)((int)area.getHeight() / 4) : (double)((int)area.getWidth() / 4);
        double d = r * 0.7;
        double dx = d * Math.cos(0.5235987755982988);
        double dy = d * Math.sin(0.5235987755982988);
        Area[] circles = new Area[3];
        circles[AREAS.A.ordinal()] = new Area(new Ellipse2D.Double(area.getCenterX() - r, area.getCenterY() - d - r, 2.0 * r, 2.0 * r));
        circles[AREAS.B.ordinal()] = new Area(new Ellipse2D.Double(area.getCenterX() - dx - r, area.getCenterY() + dy - r, 2.0 * r, 2.0 * r));
        circles[AREAS.C.ordinal()] = new Area(new Ellipse2D.Double(area.getCenterX() + dx - r, area.getCenterY() + dy - r, 2.0 * r, 2.0 * r));
        if (this.areas[0] == null) {
            for (int i = 0; i < this.areas.length; ++i) {
                this.areas[i] = new Area();
            }
        } else {
            for (Area a : this.areas) {
                a.reset();
            }
        }
        this.areas[AREAS.A.ordinal()].add(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.A.ordinal()].subtract(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.A.ordinal()].subtract(circles[AREAS.C.ordinal()]);
        this.areas[AREAS.B.ordinal()].add(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.B.ordinal()].subtract(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.B.ordinal()].subtract(circles[AREAS.C.ordinal()]);
        this.areas[AREAS.C.ordinal()].add(circles[AREAS.C.ordinal()]);
        this.areas[AREAS.C.ordinal()].subtract(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.C.ordinal()].subtract(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.AB.ordinal()].add(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.AB.ordinal()].intersect(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.AB.ordinal()].subtract(circles[AREAS.C.ordinal()]);
        this.areas[AREAS.BC.ordinal()].add(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.BC.ordinal()].subtract(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.BC.ordinal()].intersect(circles[AREAS.C.ordinal()]);
        this.areas[AREAS.AC.ordinal()].add(circles[AREAS.C.ordinal()]);
        this.areas[AREAS.AC.ordinal()].intersect(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.AC.ordinal()].subtract(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.ABC.ordinal()].add(circles[AREAS.A.ordinal()]);
        this.areas[AREAS.ABC.ordinal()].intersect(circles[AREAS.B.ordinal()]);
        this.areas[AREAS.ABC.ordinal()].intersect(circles[AREAS.C.ordinal()]);
        if (info != null) {
            for (Area shape : this.areas) {
                this.createEntity(shape, info);
            }
        }
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent event) {
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent e) {
        if (e.getEntity() != null) {
            for (Area shape : this.areas) {
                if (!shape.equals(e.getEntity().getArea())) continue;
                if (!e.getTrigger().isControlDown()) {
                    this.selected.clear();
                }
                if (this.selected.contains(shape)) {
                    this.selected.remove(shape);
                    continue;
                }
                this.selected.add(shape);
            }
        } else {
            this.selected.clear();
        }
        this.setSelectedForList(true);
    }

    public void setSelectedForList(boolean dispatchEvent) {
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<DataBean, Set<Integer>> indexes = new HashMap<DataBean, Set<Integer>>();
        for (int i = 0; i < this.areas.length; ++i) {
            if (!this.selected.contains(this.areas[i])) continue;
            ids.addAll(this.dataset.getIdentifiers(AREAS.values()[i]));
            Map<DataBean, Set<Integer>> map = this.dataset.getIndexes(AREAS.values()[i]);
            for (DataBean data : map.keySet()) {
                if (!indexes.containsKey(data)) {
                    indexes.put(data, new HashSet());
                }
                ((Set)indexes.get(data)).addAll((Collection)map.get(data));
            }
        }
        this.visualisation.setSelectedListContent(ids, indexes, this, dispatchEvent);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VenndiPlot)) {
            return false;
        }
        VenndiPlot that = (VenndiPlot)obj;
        return ObjectUtilities.equal(this.descriptionFont, that.descriptionFont);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void createEntity(Shape shape, PlotRenderingInfo info) {
        EntityCollection entities;
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            entities.add(new ChartEntity(shape));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AREAS {
        A,
        B,
        C,
        AB,
        AC,
        BC,
        ABC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VennDataset {
        private String[][] idsBySection;
        private List<DataBean> datasets;
        private Map<DataBean, Map<String, Integer>> indexMaps;

        public VennDataset(String[][] idsBySection, List<DataBean> datas, Map<DataBean, Map<String, Integer>> indexMaps2) {
            this.idsBySection = idsBySection;
            this.datasets = datas;
            this.indexMaps = indexMaps2;
        }

        public int getCount(AREAS area) {
            return this.idsBySection[area.ordinal()].length;
        }

        public String getDatasetName(AREAS area) {
            if (area.ordinal() < this.datasets.size()) {
                return this.datasets.get(area.ordinal()).getName();
            }
            return "";
        }

        public List<DataBean> getDataBeans() {
            return this.datasets;
        }

        public Collection<String> getIdentifiers(AREAS areas) {
            return Arrays.asList(this.idsBySection[areas.ordinal()]);
        }

        public Map<DataBean, Set<Integer>> getIndexes(AREAS area) {
            HashMap<DataBean, Set<Integer>> indexes = new HashMap<DataBean, Set<Integer>>();
            for (DataBean data : this.datasets) {
                indexes.put(data, new HashSet());
                for (String id : this.getIdentifiers(area)) {
                    ((Set)indexes.get(data)).add(this.indexMaps.get(data).get(id));
                }
            }
            return indexes;
        }
    }
}

