/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class MicroarrayTable
extends JXTable
implements ActionListener,
PropertyChangeListener {
    private Clipboard systemClipboard;
    private static ClientApplication application = Session.getSession().getApplication();
    private static Logger logger = Logger.getLogger(MicroarrayTable.class);
    private boolean doNotDispatchEvents = true;
    private DataBean data;

    public MicroarrayTable(DataBean data) {
        this.data = data;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.registerKeyboardAction(this, "Copy", copy, 0);
        this.registerKeyboardAction(this, "Paste", paste, 0);
        this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!MicroarrayTable.this.doNotDispatchEvents) {
                    logger.debug("Row selection of the table changed");
                    int[] selected = MicroarrayTable.this.getSelectedRows();
                    int[] converted = new int[selected.length];
                    for (int i = 0; i < selected.length; ++i) {
                        converted[i] = MicroarrayTable.this.convertRowIndexToModel(selected[i]);
                    }
                    boolean tmp = MicroarrayTable.this.doNotDispatchEvents;
                    MicroarrayTable.this.doNotDispatchEvents = true;
                    application.getSelectionManager().getRowSelectionManager(MicroarrayTable.this.data).setSelected(converted, (Object)MicroarrayTable.this);
                    MicroarrayTable.this.doNotDispatchEvents = tmp;
                }
            }
        });
        application.addPropertyChangeListener(this);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component cell = super.prepareRenderer(renderer, row, column);
        if (this.isColumnSelected(column) && this.isRowSelected(row)) {
            cell.setBackground(this.getSelectionBackground());
            cell.setForeground(this.getSelectionForeground());
        } else {
            cell.setBackground(this.getBackground());
            cell.setForeground(this.getForeground());
        }
        return cell;
    }

    public void sendEvents(boolean value) {
        this.doNotDispatchEvents = !value;
    }

    public void copy() {
        StringBuffer selectedValues = new StringBuffer();
        int numColsSelected = this.getSelectedColumnCount();
        int numRowsSelected = this.getSelectedRowCount();
        int[] rowsSelected = this.getSelectedRows();
        int[] colsSelected = this.getSelectedColumns();
        if (numColsSelected == 1 && numRowsSelected == 1) {
            selectedValues.append(this.getValueAt(rowsSelected[0], colsSelected[0]));
        } else {
            for (int row = 0; row < numRowsSelected; ++row) {
                for (int col = 0; col < numColsSelected; ++col) {
                    selectedValues.append(this.getValueAt(rowsSelected[row], colsSelected[col]));
                    if (col >= numColsSelected - 1) continue;
                    selectedValues.append("\t");
                }
                selectedValues.append("\n");
            }
        }
        StringSelection stringToClipboard = new StringSelection(selectedValues.toString());
        this.systemClipboard.setContents(stringToClipboard, stringToClipboard);
    }

    public void paste() {
        int i;
        int[] targetColsModel;
        int[] targetRowsModel;
        int[] selectedRowsView = this.getSelectedRows();
        int[] selectedColsView = this.getSelectedColumns();
        if (selectedRowsView.length < 1) {
            logger.warn("paste with no selected rows");
            return;
        }
        if (selectedColsView.length < 1) {
            logger.warn("paste with no selected columns");
        }
        ArrayList<List<String>> clipboardRows = new ArrayList<List<String>>();
        try {
            String fromClipboard = (String)this.systemClipboard.getData(DataFlavor.stringFlavor);
            for (String row : fromClipboard.split("\n", -1)) {
                clipboardRows.add(Arrays.asList(row.split("\t", -1)));
            }
            if (clipboardRows.size() > 1) {
                clipboardRows.remove(clipboardRows.size() - 1);
            }
        }
        catch (Exception e) {
            application.showDialog("Paste failed.", "Could not get the contents of the clipboard.", e.toString(), DialogInfo.Severity.INFO, true);
            return;
        }
        ArrayList<int[]> modifiedCells = new ArrayList<int[]>();
        if (selectedRowsView.length == 1 && selectedColsView.length == 1) {
            int targetAreaHeight = this.getRowCount() - selectedRowsView[0] >= clipboardRows.size() ? clipboardRows.size() : this.getRowCount() - selectedRowsView[0];
            int clipboardContentWidthMax = 0;
            for (List list : clipboardRows) {
                if (list.size() <= clipboardContentWidthMax) continue;
                clipboardContentWidthMax = list.size();
            }
            int targetAreaWidth = this.getColumnCount() - selectedColsView[0] >= clipboardContentWidthMax ? clipboardContentWidthMax : this.getColumnCount() - selectedColsView[0];
            targetRowsModel = new int[targetAreaHeight];
            for (int i2 = 0; i2 < targetAreaHeight; ++i2) {
                targetRowsModel[i2] = this.convertRowIndexToModel(selectedRowsView[0] + i2);
            }
            targetColsModel = new int[targetAreaWidth];
            for (int i2 = 0; i2 < targetAreaWidth; ++i2) {
                targetColsModel[i2] = this.convertColumnIndexToModel(selectedColsView[0] + i2);
            }
        } else {
            targetRowsModel = new int[selectedRowsView.length];
            for (i = 0; i < selectedRowsView.length; ++i) {
                targetRowsModel[i] = this.convertRowIndexToModel(selectedRowsView[i]);
            }
            targetColsModel = new int[selectedColsView.length];
            for (i = 0; i < selectedColsView.length; ++i) {
                targetColsModel[i] = this.convertColumnIndexToModel(selectedColsView[i]);
            }
        }
        for (i = 0; i < targetRowsModel.length; ++i) {
            for (int j = 0; j < targetColsModel.length; ++j) {
                int targetColView;
                List clipboardRow = (List)clipboardRows.get(i % clipboardRows.size());
                int targetRowModel = targetRowsModel[i];
                int n = targetColsModel[j];
                int targetRowView = this.convertRowIndexToView(targetRowModel);
                if (!this.isCellEditable(targetRowView, targetColView = this.convertColumnIndexToView(n))) continue;
                this.setValueAt(clipboardRow.get(j % clipboardRow.size()), targetRowView, targetColView);
                modifiedCells.add(new int[]{targetRowModel, n});
            }
        }
        this.setSelectionMode(2);
        this.clearSelection();
        for (int[] modifiedCell : modifiedCells) {
            int selectionRowView = this.convertRowIndexToView(modifiedCell[0]);
            int selectionColView = this.convertColumnIndexToView(modifiedCell[1]);
            this.changeSelection(selectionRowView, selectionColView, true, false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copy();
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            this.paste();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (logger.isDebugEnabled() && evt instanceof RowChoiceEvent) {
            logger.debug("Got a RowChoiceEvent from \n" + evt.getSource());
        }
        if (evt instanceof RowChoiceEvent && evt.getSource() != this && ((RowChoiceEvent)evt).getData() == this.data) {
            logger.debug("RowChoiceEvent not from Spreadsheet");
            this.updateSelectionsFromApplication();
        }
    }

    public void updateSelectionsFromApplication() {
        logger.debug("Updating selections from application");
        boolean tmp = this.doNotDispatchEvents;
        this.doNotDispatchEvents = true;
        this.getSelectionModel().clearSelection();
        this.setSelectionMode(2);
        for (int row : application.getSelectionManager().getRowSelectionManager(this.data).getSelectedRows()) {
            this.changeSelection(this.convertRowIndexToView(row), 0, true, false);
        }
        this.doNotDispatchEvents = tmp;
    }
}

