/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.util.IOUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.SwingPropertyChangeSupport;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutor {
    private static final Logger logger = Logger.getLogger(TaskExecutor.class);
    private DataManager manager;
    private FileBrokerClient fileBroker;
    private MessagingTopic requestTopic;
    private LinkedList<Task> tasks = new LinkedList();
    private LinkedList<Task> runningTasks = new LinkedList();
    private SwingPropertyChangeSupport jobExecutorStateChangeSupport;
    private boolean eventsEnabled = false;

    public TaskExecutor(MessagingEndpoint endpoint, DataManager manager) throws JMSException {
        this.manager = manager;
        this.fileBroker = new FileBrokerClient(endpoint.createTopic(Topics.Name.URL_TOPIC, MessagingTopic.AccessMode.WRITE));
        this.requestTopic = endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.jobExecutorStateChangeSupport = new SwingPropertyChangeSupport(this);
    }

    protected TaskExecutor(DataManager manager) throws JMSException {
        this.manager = manager;
        this.jobExecutorStateChangeSupport = new SwingPropertyChangeSupport(this);
    }

    public Task createTask(String name) {
        return this.createTask(name, false);
    }

    public Task createTask(String name, boolean hidden) {
        Task task = new Task(name, hidden);
        return task;
    }

    public void startExecuting(Task task) throws TaskException {
        this.startExecuting(task, -1);
    }

    public void startExecuting(final Task task, int timeout) throws TaskException {
        logger.debug("Starting task " + task.getName());
        try {
            List<String> parameters = task.getParameters();
            logger.debug("we have " + parameters.size() + " parameters");
            for (String parameter : parameters) {
                logger.debug("parameter: " + parameter);
            }
        }
        catch (MicroarrayException e1) {
            logger.error("Could not log parameters.");
        }
        task.setStartTime(System.currentTimeMillis());
        this.addToRunningTasks(task);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JobMessage jobMessage = new JobMessage(task.getId(), task.getName(), task.getParameters());
                    logger.debug("adding inputs to job message");
                    TaskExecutor.this.updateTaskState(task, Task.State.TRANSFERRING_INPUTS, null, -1);
                    int i = 0;
                    for (final String name : task.inputNames()) {
                        final int fi = i;
                        IOUtils.CopyProgressListener progressListener = new IOUtils.CopyProgressListener(){
                            int length;
                            {
                                this.length = (int)task.getInput(name).getContentLength();
                            }

                            public void progress(int bytes) {
                                float overall = (float)fi / (float)task.getInputCount();
                                float infile = (float)bytes / (float)this.length;
                                float p = overall + infile / (float)task.getInputCount();
                                TaskExecutor.this.updateTaskState(task, Task.State.TRANSFERRING_INPUTS, null, Math.round(p * 100.0f));
                            }
                        };
                        DataBean bean = task.getInput(name);
                        try {
                            bean.lockContent();
                            if (bean.isContentChanged()) {
                                bean.setUrl(TaskExecutor.this.fileBroker.addFile(bean.getContentByteStream(), progressListener));
                                bean.setContentChanged(false);
                            } else if (bean.getUrl() != null && !TaskExecutor.this.fileBroker.checkFile(bean.getUrl(), bean.getContentLength())) {
                                bean.setUrl(TaskExecutor.this.fileBroker.addFile(bean.getContentByteStream(), progressListener));
                            }
                        }
                        finally {
                            bean.unlockContent();
                        }
                        jobMessage.addPayload(name, bean.getUrl());
                        logger.debug("added input " + name + " to job message.");
                        ++i;
                    }
                    TaskExecutor.this.updateTaskState(task, Task.State.WAITING, null, -1);
                    ResultMessageListener replyListener = new ResultMessageListener(task);
                    logger.debug("sending job message, jobId: " + jobMessage.getJobId());
                    TaskExecutor.this.requestTopic.sendReplyableMessage(jobMessage, replyListener);
                }
                catch (Exception e) {
                    logger.error("Could not send job message.", e);
                    TaskExecutor.this.updateTaskState(task, Task.State.ERROR, "Sending message failed", -1);
                    TaskExecutor.this.removeFromRunningTasks(task);
                }
            }
        }).start();
        logger.debug("task starter thread started");
        if (timeout != -1) {
            Timer timer = new Timer(timeout, new TimeoutListener(task));
            timer.setRepeats(false);
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) throws TaskException {
        this.startExecuting(task);
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            while (!task.getState().isFinished()) {
                try {
                    this.runningTasks.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(Task task) {
        logger.debug("TaskExecutor killing task " + task.getId());
        Task task2 = task;
        synchronized (task2) {
            if (task.getState().isFinished()) {
                logger.debug("Task already finished, no need to cancel.");
                return;
            }
            this.updateTaskState(task, Task.State.CANCELLED, null, -1);
        }
        this.sendCancelMessage(task);
        this.removeFromRunningTasks(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            LinkedList<Task> tasksToKill = new LinkedList<Task>();
            for (Task task : this.runningTasks) {
                tasksToKill.add(task);
            }
            for (Task task : tasksToKill) {
                this.kill(task);
            }
            this.runningTasks.clear();
            SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Task> getTasks(boolean onlyRunning, boolean showHidden) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            LinkedList<Task> taskList;
            LinkedList<Task> linkedList2 = taskList = onlyRunning ? this.runningTasks : this.tasks;
            if (showHidden) {
                return taskList;
            }
            LinkedList<Task> prunedTaskList = new LinkedList<Task>();
            for (Task task : taskList) {
                if (task.isHidden()) continue;
                prunedTaskList.add(task);
            }
            return prunedTaskList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningTaskCount() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            Collection<Task> taskList = this.getTasks(true, false);
            return taskList.size();
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.jobExecutorStateChangeSupport.addPropertyChangeListener(listener);
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskState(Task task, Task.State state, String stateDetail, int completionPercentage) {
        Task task2 = task;
        synchronized (task2) {
            if (task.getState().isFinished()) {
                return;
            }
            task.setState(state);
            if (stateDetail != null) {
                task.setStateDetail(stateDetail);
            }
            task.setCompletionPercentage(completionPercentage);
            SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
        }
    }

    private void dispatch(PropertyChangeEvent event) {
        if (this.eventsEnabled) {
            this.jobExecutorStateChangeSupport.firePropertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRunningTasks(Task task) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.runningTasks.add(task);
            this.runningTasks.notifyAll();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromRunningTasks(Task task) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.runningTasks.remove(task);
            this.runningTasks.notifyAll();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    private void sendCancelMessage(final Task task) {
        logger.debug("Sending cancel message for " + task.getId());
        new Thread(new Runnable(){

            public void run() {
                try {
                    CommandMessage commandMessage = new CommandMessage("cancel");
                    commandMessage.addParameter(task.getId());
                    logger.debug("Sending cancel message.");
                    TaskExecutor.this.requestTopic.sendMessage(commandMessage);
                }
                catch (Exception e) {
                    logger.error("Could not send cancel message for " + task.getId(), e);
                }
            }
        }).start();
        logger.debug("Message cancel thread started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resendJobMessage(Task task, Destination replyTo) throws TaskException, MicroarrayException, JMSException, IOException, FileBrokerException {
        JobMessage jobMessage = new JobMessage(task.getId(), task.getName(), task.getParameters());
        for (String name : task.inputNames()) {
            DataBean bean = task.getInput(name);
            try {
                bean.lockContent();
                bean.setUrl(this.fileBroker.addFile(bean.getContentByteStream(), null));
                bean.setContentChanged(false);
            }
            finally {
                bean.unlockContent();
            }
            jobMessage.addPayload(name, bean.getUrl());
        }
        jobMessage.setReplyTo(replyTo);
        logger.debug("Retry replyTo is: " + jobMessage.getReplyTo());
        this.requestTopic.sendMessage(jobMessage);
    }

    private class ResultMessageListener
    extends TempTopicMessagingListenerBase {
        Task pendingTask;
        ResultListenerState internalState;
        String asId;

        public ResultMessageListener(Task pendingTask) {
            this.pendingTask = pendingTask;
            this.internalState = pendingTask.getName().equals("describe") || pendingTask.getName().equals("describe-operation") ? ResultListenerState.WAIT_FOR_STATUS : ResultListenerState.WAIT_FOR_ACK;
        }

        public void onNamiMessage(NamiMessage msg) {
            ResultMessage resultMessage;
            logger.debug("Task " + this.pendingTask.getId() + " got message (" + msg.getMessageID() + ") of type " + msg.getClass().getName());
            if (this.internalState.equals((Object)ResultListenerState.FINISHED)) {
                return;
            }
            if (this.pendingTask.getState().isFinished()) {
                logger.debug("Task " + this.pendingTask.getId() + " already finished, ignoring message.");
                this.internalState = ResultListenerState.FINISHED;
                return;
            }
            if (msg instanceof ResultMessage && JobState.ERROR.equals((Object)(resultMessage = (ResultMessage)msg).getState())) {
                logger.debug("Task " + this.pendingTask.getId() + " got result message with ERROR.");
                this.taskFinished(Task.State.ERROR, resultMessage.getStateDetail(), resultMessage);
                return;
            }
            block4 : switch (this.internalState) {
                case WAIT_FOR_ACK: {
                    if (!(msg instanceof CommandMessage)) break;
                    CommandMessage commandMessage = (CommandMessage)msg;
                    if ("acknowledge".equals(commandMessage.getCommand())) {
                        logger.debug("Got ACK message.");
                        this.internalState = ResultListenerState.WAIT_FOR_OFFER;
                        break;
                    }
                    if (!"offer".equals(commandMessage.getCommand())) break;
                    this.asId = commandMessage.getNamedParameter("as-id");
                    logger.debug("Got OFFER from " + this.asId);
                    this.internalState = ResultListenerState.WAIT_FOR_STATUS;
                    CommandMessage acceptMessage = new CommandMessage("choose");
                    acceptMessage.addNamedParameter("job-id", this.pendingTask.getId());
                    acceptMessage.addNamedParameter("as-id", this.asId);
                    logger.debug("Sending ACCEPT_OFFER to " + this.asId);
                    try {
                        TaskExecutor.this.requestTopic.sendMessage(acceptMessage);
                    }
                    catch (JMSException e) {
                        logger.error("Could not send accept message.", e);
                        this.pendingTask.setErrorMessage(e.toString());
                        this.taskFinished(Task.State.ERROR, "Sending message failed", null);
                    }
                    break;
                }
                case WAIT_FOR_OFFER: {
                    CommandMessage commandMessage;
                    if (!(msg instanceof CommandMessage) || !"offer".equals((commandMessage = (CommandMessage)msg).getCommand())) break;
                    this.asId = commandMessage.getNamedParameter("as-id");
                    this.internalState = ResultListenerState.WAIT_FOR_STATUS;
                    CommandMessage acceptMessage = new CommandMessage("choose");
                    acceptMessage.addNamedParameter("job-id", this.pendingTask.getId());
                    acceptMessage.addNamedParameter("as-id", this.asId);
                    try {
                        TaskExecutor.this.requestTopic.sendMessage(acceptMessage);
                    }
                    catch (JMSException e) {
                        logger.error("Could not send accept message.", e);
                        this.pendingTask.setErrorMessage(e.toString());
                        this.taskFinished(Task.State.ERROR, "Sending message failed", null);
                    }
                    break;
                }
                case WAIT_FOR_STATUS: {
                    if (!(msg instanceof ResultMessage)) break;
                    resultMessage = (ResultMessage)msg;
                    JobState jobState = resultMessage.getState();
                    switch (jobState) {
                        case NEW: {
                            break block4;
                        }
                        case RUNNING: {
                            TaskExecutor.this.updateTaskState(this.pendingTask, Task.State.RUNNING, resultMessage.getStateDetail(), -1);
                            break block4;
                        }
                        case COMPLETED: {
                            TaskExecutor.this.updateTaskState(this.pendingTask, Task.State.TRANSFERRING_OUTPUTS, null, -1);
                            try {
                                this.extractPayloads(resultMessage);
                            }
                            catch (Exception e) {
                                logger.error("Getting outputs failed", e);
                                this.pendingTask.setErrorMessage(e.toString());
                                this.taskFinished(Task.State.ERROR, "Transferring outputs failed", null);
                                break block4;
                            }
                            this.taskFinished(Task.State.COMPLETED, null, resultMessage);
                            break block4;
                        }
                        case FAILED: {
                            this.taskFinished(Task.State.FAILED, resultMessage.getStateDetail(), resultMessage);
                            break block4;
                        }
                        case FAILED_USER_ERROR: {
                            this.taskFinished(Task.State.FAILED_USER_ERROR, resultMessage.getStateDetail(), resultMessage);
                            break block4;
                        }
                        case TIMEOUT: {
                            this.taskFinished(Task.State.FAILED, resultMessage.getStateDetail(), resultMessage);
                            break block4;
                        }
                        case RETRY: {
                            if (!this.pendingTask.hasBeenRetried()) {
                                logger.debug("Resending job " + this.pendingTask.getId());
                                this.pendingTask.changeId();
                                try {
                                    TaskExecutor.this.resendJobMessage(this.pendingTask, resultMessage.getReplyTo());
                                }
                                catch (Exception e) {
                                    logger.error("Could not resend job " + this.pendingTask.getId(), e);
                                    this.pendingTask.setErrorMessage(e.toString());
                                    this.taskFinished(Task.State.ERROR, "Resending job failed", null);
                                }
                                this.pendingTask.setHasBeenRetried(true);
                                break block4;
                            }
                            logger.error("Not resending the job message for the second time " + this.pendingTask.getId());
                            this.pendingTask.setErrorMessage("Resending task failed.");
                            this.taskFinished(Task.State.ERROR, "Retransferring data failed", null);
                        }
                    }
                }
            }
            if (this.pendingTask.getState().isFinished() && this.internalState != ResultListenerState.FINISHED) {
                this.internalState = ResultListenerState.FINISHED;
            }
        }

        private void extractPayloads(ResultMessage resultMessage) throws JMSException, MicroarrayException, IOException {
            for (String name : resultMessage.payloadNames()) {
                logger.debug("output " + name);
                URL payloadUrl = resultMessage.getPayload(name);
                InputStream payload = TaskExecutor.this.fileBroker.getFile(payloadUrl);
                DataBean bean = TaskExecutor.this.manager.createDataBean(name, payload);
                bean.setUrl(payloadUrl);
                bean.setContentChanged(false);
                this.pendingTask.addOutput(name, bean);
            }
        }

        private void taskFinished(Task.State state, String stateDetail, ResultMessage resultMessage) {
            if (resultMessage != null) {
                if (resultMessage.getOutputText() != null) {
                    this.pendingTask.setScreenOutput(resultMessage.getOutputText());
                }
                if (resultMessage.getErrorMessage() != null) {
                    this.pendingTask.setErrorMessage(resultMessage.getErrorMessage());
                }
            }
            this.pendingTask.setEndTime(System.currentTimeMillis());
            TaskExecutor.this.updateTaskState(this.pendingTask, state, stateDetail, -1);
            this.internalState = ResultListenerState.FINISHED;
            TaskExecutor.this.removeFromRunningTasks(this.pendingTask);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResultListenerState {
        WAIT_FOR_ACK,
        WAIT_FOR_OFFER,
        WAIT_FOR_STATUS,
        FINISHED,
        TIMEOUT;

    }

    private class TaskExecutorChangeNotifier
    implements Runnable {
        private TaskExecutor parent;

        public TaskExecutorChangeNotifier(TaskExecutor parent) {
            this.parent = parent;
        }

        public void run() {
            TaskExecutor.this.dispatch(new PropertyChangeEvent(this.parent, "runningJobCount", null, TaskExecutor.this.getRunningTaskCount()));
        }
    }

    private class TimeoutListener
    implements ActionListener {
        Task taskToMonitor;

        TimeoutListener(Task taskToMonitor) {
            this.taskToMonitor = taskToMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Task task = this.taskToMonitor;
            synchronized (task) {
                if (!this.taskToMonitor.getState().isFinished()) {
                    TaskExecutor.this.updateTaskState(this.taskToMonitor, Task.State.TIMEOUT, null, -1);
                }
            }
            TaskExecutor.this.removeFromRunningTasks(this.taskToMonitor);
            TaskExecutor.this.sendCancelMessage(this.taskToMonitor);
        }
    }
}

