/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.ColnameParameter;
import fi.csc.microarray.client.operation.parameter.DecimalParameter;
import fi.csc.microarray.client.operation.parameter.InputSelectParameter;
import fi.csc.microarray.client.operation.parameter.IntegerParameter;
import fi.csc.microarray.client.operation.parameter.MetaColnameParameter;
import fi.csc.microarray.client.operation.parameter.PercentageParameter;
import fi.csc.microarray.client.operation.parameter.SingleSelectionParameter;
import fi.csc.microarray.client.operation.parameter.StringParameter;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parameter
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Parameter.class);
    private String name;
    private String description;

    public static LinkedList<Parameter> cloneParameters(LinkedList<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        LinkedList<Parameter> clones = new LinkedList<Parameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            clones.add((Parameter)parameters.get(i).clone());
        }
        return clones;
    }

    public void setDataBindings(List<Operation.DataBinding> bindings) throws MicroarrayException {
    }

    public static Parameter createInstance(String name, VVSADLSyntax.ParameterType type, String[] options, String description, String minValue, String maxValue, String initValue) {
        Parameter parameter = null;
        logger.debug("creating instance of parameter type " + type.name() + " called " + name);
        switch (type) {
            case ENUM: {
                int initIndex = initValue != null ? Arrays.asList(options).indexOf(initValue) : 0;
                SingleSelectionParameter.SelectionOption[] optionObjects = SingleSelectionParameter.SelectionOption.convertStrings(options);
                parameter = new SingleSelectionParameter(name, description, optionObjects, initIndex);
                break;
            }
            case COLUMN_SEL: {
                parameter = new ColnameParameter(name, description, initValue);
                break;
            }
            case METACOLUMN_SEL: {
                parameter = new MetaColnameParameter(name, description, initValue);
                break;
            }
            case INPUT_SEL: {
                parameter = new InputSelectParameter(name, description, initValue);
                break;
            }
            case STRING: {
                parameter = new StringParameter(name, description, initValue);
                break;
            }
            case INTEGER: 
            case DECIMAL: 
            case PERCENT: {
                float max;
                float min = minValue == null ? Float.MIN_VALUE : Float.parseFloat(minValue);
                float f = max = maxValue == null ? Float.MAX_VALUE : Float.parseFloat(maxValue);
                float init = initValue == null ? (min > 0.0f ? min : 0.0f) : Float.parseFloat(initValue);
                switch (type) {
                    case INTEGER: {
                        parameter = new IntegerParameter(name, description, (int)min, (int)max, (int)init);
                        break;
                    }
                    case DECIMAL: {
                        parameter = new DecimalParameter(name, description, min, max, init);
                        break;
                    }
                    case PERCENT: {
                        min = min < 0.0f ? 0.0f : min;
                        max = max > 100.0f ? 100.0f : max;
                        parameter = new PercentageParameter(name, description, (int)min, (int)max, (int)init);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type " + (Object)((Object)type));
            }
        }
        return parameter;
    }

    protected Parameter(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public abstract Object getValue();

    public abstract String getValueAsJava();

    public abstract void setValue(Object var1) throws IllegalArgumentException;

    public abstract void parseValue(String var1) throws IllegalArgumentException;

    public abstract boolean checkValidityOf(Object var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract String toString();

    public String getDescription() {
        return this.description;
    }
}

