/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.description.VVSADLParser;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationDefinition
implements ExecutionItem {
    private static final Logger logger = Logger.getLogger(OperationDefinition.class);
    public static final OperationDefinition IMPORT_DEFINITION;
    public static final OperationDefinition USER_MODIFICATION_DEFINITION;
    public static String IDENTIFIER_SEPARATOR;
    private static Map<String, OperationDefinition> instances;
    private String name;
    private OperationCategory category;
    private LinkedList<Parameter> parameters = new LinkedList();
    private String description;
    private int colorCount;
    private int outputCount = 0;
    private LinkedList<InputDefinition> inputs = new LinkedList();
    Suitability evaluatedSuitability = null;
    private boolean hasSourceCode;

    public static OperationDefinition getInstance(String identifier) {
        return instances.get(identifier);
    }

    public OperationDefinition(String name, OperationCategory category, String description, boolean hasSourceCode) {
        this.name = name;
        this.category = category;
        this.hasSourceCode = hasSourceCode;
        if (category != null) {
            category.addOperation(this);
        }
        this.description = description;
        instances.put(name + IDENTIFIER_SEPARATOR + category.getName(), this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OperationCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCategoryName() {
        return this.category.getName();
    }

    public String getFullName() {
        return this.getCategoryName() + " / " + this.getName();
    }

    public List<Parameter> getDefaultParameters() {
        return this.parameters;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getJobPhrase() {
        return VVSADLParser.generateOperationIdentifier(this.category.getName(), this.name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Suitability evaluateSuitabilityFor(Iterable<DataBean> data) {
        this.bindInputs(data);
        return this.getEvaluatedSuitability();
    }

    public LinkedList<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void addInput(String name, VVSADLSyntax.InputType type) {
        InputDefinition input = new InputDefinition(name, type);
        this.inputs.add(input);
    }

    public void addInput(String prefix, String postfix, VVSADLSyntax.InputType type) {
        InputDefinition input = new InputDefinition(prefix, postfix, type);
        this.inputs.add(input);
    }

    public LinkedList<Operation.DataBinding> bindInputs(Iterable<DataBean> inputValues) {
        LinkedList<Operation.DataBinding> bindings = new LinkedList<Operation.DataBinding>();
        LinkedList<DataBean> notProcessedInputValues = new LinkedList<DataBean>();
        for (DataBean bean : inputValues) {
            notProcessedInputValues.add(bean);
        }
        LinkedList<InputDefinition> unboundMetadataDefinitions = new LinkedList<InputDefinition>();
        logger.debug("binding " + notProcessedInputValues.size() + " values to " + this.inputs.size() + " formal inputs");
        for (InputDefinition input : this.inputs) {
            input.resetMulti();
            boolean foundBinding = false;
            if (input.name.startsWith("phenodata")) {
                foundBinding = true;
                unboundMetadataDefinitions.add(input);
                continue;
            }
            LinkedList<DataBean> removedValues = new LinkedList<DataBean>();
            for (DataBean value : notProcessedInputValues) {
                logger.debug("  trying to bind " + value.getName() + " to " + input.name + " (" + input.type + ")");
                if (!input.type.isTypeOf(value)) continue;
                logger.debug("    bound successfully (" + value.getName() + " -> " + input.getName() + ")");
                bindings.add(new Operation.DataBinding(value, input.getName(), input.type));
                foundBinding = true;
                removedValues.add(value);
                if (!input.isMulti()) break;
                input.nextMulti();
            }
            notProcessedInputValues.removeAll(removedValues);
            if (foundBinding) continue;
            logger.debug("  no binding found for " + input.name);
            this.evaluatedSuitability = Suitability.NOT_ENOUGH_INPUTS;
            return null;
        }
        if (notProcessedInputValues.size() > 0) {
            logger.debug("  " + notProcessedInputValues.size() + " concrete inputs were not bound");
            this.evaluatedSuitability = Suitability.TOO_MANY_INPUTS;
            return null;
        }
        logger.debug("we have " + bindings.size() + " bindings before metadata retrieval");
        if (!unboundMetadataDefinitions.isEmpty()) {
            Iterator bindingIterator = bindings.iterator();
            LinkedList<Operation.DataBinding> phenodataBindings = new LinkedList<Operation.DataBinding>();
            for (InputDefinition unboundMetadata : unboundMetadataDefinitions) {
                DataBean input = ((Operation.DataBinding)bindingIterator.next()).getData();
                DataBean metadata = LinkUtils.retrieveInherited(input, DataBean.Link.ANNOTATION);
                if (metadata != null) {
                    phenodataBindings.add(new Operation.DataBinding(metadata, unboundMetadata.getName(), ChipsterInputTypes.PHENODATA));
                    continue;
                }
                this.evaluatedSuitability = Suitability.NOT_ENOUGH_INPUTS;
                return null;
            }
            bindings.addAll(phenodataBindings);
        }
        logger.debug("we have " + bindings.size() + " bindings after metadata retrieval");
        this.evaluatedSuitability = Suitability.SUITABLE;
        return bindings;
    }

    public Suitability getEvaluatedSuitability() {
        return this.evaluatedSuitability;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    public void setSourceCode(boolean hasSourceCode) {
        this.hasSourceCode = hasSourceCode;
    }

    static {
        IDENTIFIER_SEPARATOR = "/";
        instances = new HashMap<String, OperationDefinition>();
        IMPORT_DEFINITION = new OperationDefinition("Raw data import", OperationCategory.IMPORT_CATEGORY, "Imports raw microarray data from an external file.", false);
        USER_MODIFICATION_DEFINITION = new OperationDefinition("User modified", OperationCategory.USER_MODIFICATION_CATEGORY, "User had edited bean content.", false);
    }

    public static class InputDefinition {
        private String name;
        private String postfix = null;
        private boolean multi = false;
        private int multiCounter;
        private VVSADLSyntax.InputType type;

        public InputDefinition(String name, VVSADLSyntax.InputType type) {
            this.resetMulti();
            this.name = name;
            this.type = type;
        }

        public InputDefinition(String prefix, String postfix, VVSADLSyntax.InputType type) {
            this.name = prefix;
            this.postfix = postfix;
            this.type = type;
            this.multi = true;
        }

        private String getName() {
            if (!this.multi) {
                return this.name;
            }
            return this.name + Strings.toString(this.multiCounter, 3) + this.postfix;
        }

        private void nextMulti() {
            ++this.multiCounter;
        }

        public boolean isMulti() {
            return this.multi;
        }

        public void resetMulti() {
            this.multiCounter = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Suitability {
        SUITABLE,
        IMPOSSIBLE,
        ALREADY_DONE,
        TOO_MANY_INPUTS,
        NOT_ENOUGH_INPUTS;

        private static final Color GREEN;
        private static final Color YELLOW;
        private static final Color RED;
        private static final Color COLOR_ALREADY_DONE;

        public boolean isImpossible() {
            return this == IMPOSSIBLE || this == NOT_ENOUGH_INPUTS || this == TOO_MANY_INPUTS;
        }

        public boolean isOk() {
            return this == SUITABLE;
        }

        public Color getIndicatorColor() {
            if (this.isImpossible()) {
                return RED;
            }
            if (this.isOk()) {
                return GREEN;
            }
            if (this == ALREADY_DONE) {
                return COLOR_ALREADY_DONE;
            }
            return YELLOW;
        }

        public String toString() {
            switch (this) {
                case SUITABLE: {
                    return "Suitable";
                }
                case IMPOSSIBLE: {
                    return "Impossible";
                }
                case ALREADY_DONE: {
                    return "Already done";
                }
                case TOO_MANY_INPUTS: {
                    return "Too many inputs";
                }
                case NOT_ENOUGH_INPUTS: {
                    return "Not enough inputs";
                }
            }
            throw new RuntimeException("unknown suitability: " + this.name());
        }

        static {
            GREEN = new Color(52, 196, 49);
            YELLOW = new Color(196, 186, 49);
            RED = new Color(196, 49, 49);
            COLOR_ALREADY_DONE = new Color(230, 180, 250);
        }
    }
}

