/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
implements ExecutionItem {
    private static final Logger logger = Logger.getLogger(Operation.class);
    private OperationDefinition definition;
    private LinkedList<DataBinding> bindings = new LinkedList();
    private LinkedList<Parameter> parameters;
    private ResultListener resultListener;
    private DataFolder outputFolder;

    public Operation(OperationDefinition definition, DataBean[] beans) throws MicroarrayException {
        logger.debug("created operation from definition " + definition.getName());
        this.definition = definition;
        this.parameters = Parameter.cloneParameters(definition.getParameters());
        this.bindInputs(beans);
    }

    public Operation(Operation o) throws MicroarrayException {
        logger.debug("cloned operation from " + o.getName());
        this.definition = o.definition;
        this.bindings = o.bindings;
        this.parameters = Parameter.cloneParameters(o.getParameters());
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }

    public LinkedList<Parameter> getParameters() {
        return this.parameters;
    }

    public void bindInputs(DataBean[] beans) throws MicroarrayException {
        this.bindings = this.definition.bindInputs(Arrays.asList(beans));
        for (Parameter parameter : this.parameters) {
            if (this.bindings == null) {
                parameter.setDataBindings(new LinkedList<DataBinding>());
                continue;
            }
            parameter.setDataBindings(this.bindings);
        }
    }

    public void clearBindings() {
        this.bindings = null;
    }

    public List<DataBinding> getBindings() {
        return this.bindings;
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    @Override
    public String getDescription() {
        return this.definition.getDescription();
    }

    @Override
    public String getCategoryName() {
        return this.definition.getCategory().getName();
    }

    public Color getCategoryColor() {
        return this.definition.getCategory().getColor();
    }

    public String toString() {
        return this.definition.getName();
    }

    @Override
    public OperationDefinition.Suitability evaluateSuitabilityFor(Iterable<DataBean> data) {
        return this.definition.evaluateSuitabilityFor(data);
    }

    public void execute(TaskEventListener listener) {
        TaskExecutor je = Session.getSession().getJobExecutor("client-job-executor");
        Task job = je.createTask(this.definition.getJobPhrase());
        job.addTaskEventListener(listener);
        try {
            for (DataBinding binding : this.bindings) {
                logger.debug("added input " + binding.name + " to job");
                job.addInput(binding.name, binding.data);
            }
            for (Parameter parameter : this.parameters) {
                logger.debug("operation has parameter value " + parameter.getValue());
                job.addParameter(parameter.getName(), parameter.getValue());
            }
            je.startExecuting(job);
        }
        catch (TaskException jex) {
            Session.getSession().getApplication().reportException(jex);
        }
    }

    public void setParameter(String name, Object value) {
        this.getParameter(name).setValue(value);
    }

    public void parseParameter(String name, String stringValue) {
        this.getParameter(name).parseValue(stringValue);
    }

    public Parameter getParameter(String name) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public int getColorCount() {
        return this.definition.getColorCount();
    }

    public ResultListener getResultListener() {
        return this.resultListener;
    }

    public void setResultListener(ResultListener resultListener) {
        this.resultListener = resultListener;
    }

    public DataFolder getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(DataFolder outputFolder) {
        this.outputFolder = outputFolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResultListener {
        public void resultData(Iterable<DataBean> var1);

        public void noResults();
    }

    public static class DataBinding {
        private DataBean data;
        private String name;
        private VVSADLSyntax.InputType inputType;

        public DataBinding(DataBean data, String name, VVSADLSyntax.InputType inputType) {
            this.data = data;
            this.name = name;
            this.inputType = inputType;
        }

        public DataBean getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }

        public VVSADLSyntax.InputType getInputType() {
            return this.inputType;
        }
    }
}

