/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataviews.vertexes;

import fi.csc.microarray.client.dataview.MicroarrayGraph;
import fi.csc.microarray.client.dataview.PositionChangeAnimator;
import fi.csc.microarray.client.dataviews.vertexes.GraphVertex;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataItem;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

public abstract class AbstractGraphVertex
extends DefaultGraphCell {
    private MicroarrayGraph graph;
    public static Color DEFAULT_VERTEX_COLOR = VisualConstants.CATEGORY_COLORS[0];
    public static final Border BORDER_NORMAL = BorderFactory.createLineBorder(Color.black);
    public static final Stroke SELECTION_STROKE = new BasicStroke(2.0f);
    public static final Color SELECTED_BORDER_COLOR = Color.BLACK;
    public static final int DEFAULT_WIDTH = 40;
    public static final int DEFAULT_HEIGHT = 20;
    public static final int DEFAULT_MARGIN_X = 10;
    public static final int DEFAULT_MARGIN_Y = 30;

    public AbstractGraphVertex(int x, int y, DataItem data, MicroarrayGraph graph) {
        super(data);
        this.graph = graph;
        this.setPosition(new Point(x, y));
        GraphConstants.setGradientColor(this.getAttributes(), DEFAULT_VERTEX_COLOR);
        GraphConstants.setBorderColor(this.getAttributes(), Color.black);
        GraphConstants.setOpaque(this.getAttributes(), true);
    }

    public int getX() {
        return (int)this.getBounds().getX();
    }

    public int getY() {
        return (int)this.getBounds().getY();
    }

    public void setPosition(Point point) {
        Hashtable attrs = new Hashtable();
        GraphConstants.setBounds(attrs, new Rectangle2D.Double(point.getX(), point.getY(), this.getDefaultWidth(), this.getDefaultHeight()));
        this.graph.getGraphLayoutCache().editCell(this, attrs);
        this.graph.repaint();
    }

    public void setPositionAnimated(Point target) {
        new PositionChangeAnimator(this, new Point(this.getX(), this.getY()), target);
    }

    public Rectangle2D getBounds() {
        return GraphConstants.getBounds(this.getAttributes());
    }

    public MicroarrayGraph getGraph() {
        return this.graph;
    }

    public abstract int getDefaultWidth();

    public abstract int getDefaultHeight();

    public abstract String toString();

    public abstract String getToolTipString();

    public abstract void addChildVertex(GraphVertex var1);

    public abstract boolean removeChildVertex(GraphVertex var1);
}

