/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.DataColumn;
import fi.csc.microarray.client.dataimport.Delimiter;
import fi.csc.microarray.client.dataimport.FileAnalyser;
import fi.csc.microarray.client.dataimport.ImportScreenModel;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.dataimport.ProgressInformator;
import fi.csc.microarray.client.dataimport.events.ColumnTitlesChangedEvent;
import fi.csc.microarray.client.dataimport.events.ConversionModelChangeListener;
import fi.csc.microarray.client.dataimport.events.ConversionModelChangeSupport;
import fi.csc.microarray.client.dataimport.events.DecimalSeparatorChangedEvent;
import fi.csc.microarray.client.dataimport.events.DelimiterChangedEvent;
import fi.csc.microarray.client.dataimport.events.FooterChangedEvent;
import fi.csc.microarray.client.dataimport.events.HeaderChangedEvent;
import fi.csc.microarray.client.dataimport.events.InputFileChangedEvent;
import fi.csc.microarray.client.dataimport.events.TitleRowChangedEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import sun.nio.ch.ChannelInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionModel
implements ConversionModelChangeSupport {
    private static final char CHIPSTER_INTERNAL_DECIMAL_SEPARATOR = '.';
    private static final Logger logger = Logger.getLogger(ConversionModel.class);
    private static final String SAMPLE_START = "chip.";
    private Delimiter delim;
    private char decimalSeparator;
    private int headerEnd = -1;
    private int footerStart = Integer.MAX_VALUE;
    private int columnTitleLine = -1;
    private String[] columnTitles;
    private String[] cleanColumnTitles;
    private List<ConversionModelChangeListener> conversionListeners;
    private File inputFile;
    private int linesOnFile;
    private Object[][] choppedDataMatrix;
    private ImportScreenModel screen;
    private int rowLimit = Integer.MAX_VALUE;
    private int columnLimit = Integer.MAX_VALUE;
    private int maxColumnsInRow = 0;
    private FileAnalyser analyser;
    private BufferedReader buf;
    private List<File> outputFiles;
    private int lineNumber;
    private int linesRead;
    private ClientApplication application = Session.getSession().getApplication();
    private boolean isNormalised;

    public ConversionModel(ImportScreenModel screen) {
        this(screen, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ConversionModel(ImportScreenModel screen, int rowLimit, int columnLimit) {
        this.rowLimit = rowLimit;
        this.columnLimit = columnLimit;
        this.screen = screen;
        this.headerEnd = -1;
        this.footerStart = Integer.MAX_VALUE;
        this.conversionListeners = new Vector<ConversionModelChangeListener>();
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public Delimiter getDelim() {
        return this.delim;
    }

    public void setDelim(Delimiter delim) {
        this.delim = delim;
        this.fireDelimiterChangeEvent(new DelimiterChangedEvent((Object)this, delim));
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        this.fireDecimalSeparatorChangeEvent(new DecimalSeparatorChangedEvent((Object)this, Character.valueOf(decimalSeparator)));
    }

    public int getHeaderEnd() {
        return this.headerEnd;
    }

    public int getFooterStart() {
        return this.footerStart;
    }

    private String[] getDefaultColumnTitles() {
        String[] columnTitles = new String[this.getLimitedColumnCount()];
        for (int i = 0; i < columnTitles.length; ++i) {
            if (i == 0) {
                columnTitles[0] = " ";
                continue;
            }
            columnTitles[i] = "" + i;
        }
        return columnTitles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] chopData(boolean ignoreHeadersAndFooters, ProgressInformator informator) throws IOException {
        if (this.inputFile == null) {
            throw new IllegalStateException("File can not be read if no input file is set");
        }
        informator.setIndeterminate(true);
        informator.setMessage("Analysing file");
        this.analyseInputFile();
        informator.setMinimunValue(0);
        informator.setMaximumValue(this.getLimitedRowCount());
        informator.setIndeterminate(false);
        informator.setMessage("Parsing data and updating table");
        this.maxColumnsInRow = 0;
        long chopStarted = System.currentTimeMillis();
        LinkedList<Object[]> dataMatrix = new LinkedList<Object[]>();
        informator.setMessage("Reading and parsing data from file");
        boolean isLimited = false;
        this.initializeReader();
        try {
            String[] splittedLine;
            while ((splittedLine = this.nextLine(ignoreHeadersAndFooters, false)) != null && !Thread.interrupted()) {
                int dataLineLenghtLimit;
                isLimited = false;
                if (splittedLine.length >= this.columnLimit) {
                    dataLineLenghtLimit = this.columnLimit;
                    isLimited = true;
                } else {
                    dataLineLenghtLimit = splittedLine.length + 1;
                }
                if (splittedLine.length + 1 > this.maxColumnsInRow) {
                    this.maxColumnsInRow = splittedLine.length + 1;
                }
                Object[] dataLine = new Object[dataLineLenghtLimit];
                dataLine[0] = this.lineNumber;
                for (int j = 1; j < dataLineLenghtLimit; ++j) {
                    StringBuffer token = new StringBuffer(splittedLine[j - 1]);
                    if (j + 1 > this.maxColumnsInRow) {
                        this.maxColumnsInRow = j + 1;
                        if (this.columnTitles == null && this.maxColumnsInRow == this.getLimitedColumnCount()) {
                            this.fireColumnTitlesChangeEvent(new ColumnTitlesChangedEvent((Object)this, this.getDefaultColumnTitles()));
                        }
                    }
                    if (isLimited && j == dataLineLenghtLimit - 1) {
                        dataLine[j] = "...";
                        continue;
                    }
                    try {
                        Double tokenAsDouble = new Double(token.toString());
                        dataLine[j] = tokenAsDouble;
                        continue;
                    }
                    catch (NumberFormatException nfe2) {
                        dataLine[j] = token.toString();
                    }
                }
                dataMatrix.add(dataLine);
                if (this.lineNumber % this.getInformationInterval() != 0) continue;
                informator.setValue(this.lineNumber);
            }
        }
        finally {
            this.buf.close();
        }
        long chopTime = System.currentTimeMillis() - chopStarted;
        logger.debug("Chop time: " + chopTime);
        this.choppedDataMatrix = (Object[][])dataMatrix.toArray((T[])new Object[0][]);
        return this.choppedDataMatrix;
    }

    private void analyseInputFile() throws IOException {
        if (this.analyser == null) {
            this.analyser = new FileAnalyser(this.inputFile);
        }
        if (this.analyser.isSameFileAs(this.inputFile)) {
            if (!this.analyser.isAnalysed()) {
                this.analyser.startAnalysing();
                this.setDelim(this.analyser.getDelimiter());
                this.setLinesOnFile(this.analyser.getLinesOnFile());
            }
        } else {
            this.analyser.setInputFile(this.inputFile);
            this.analyser.startAnalysing();
            this.setDelim(this.analyser.getDelimiter());
            this.setLinesOnFile(this.analyser.getLinesOnFile());
        }
    }

    private void setLinesOnFile(int linesOnFile) {
        this.linesOnFile = linesOnFile;
    }

    private int getInformationInterval() {
        int interval = this.getLimitedRowCount() / 100;
        if (interval < 10) {
            return 10;
        }
        return interval;
    }

    private void initializeReader() throws FileNotFoundException {
        if (this.inputFile == null) {
            throw new IllegalStateException("Can't initialize reader while input file is null");
        }
        this.buf = new BufferedReader(new InputStreamReader(new ChannelInputStream(new RandomAccessFile(this.inputFile, "r").getChannel())));
        this.lineNumber = 0;
        this.linesRead = 0;
    }

    private int getMaximumColumnsInRow() {
        return this.maxColumnsInRow;
    }

    public int getLimitedColumnCount() {
        if (this.getMaximumColumnsInRow() > this.columnLimit) {
            return this.columnLimit;
        }
        return this.getMaximumColumnsInRow();
    }

    public int getUnlimitedColumnCount() {
        return this.getMaximumColumnsInRow();
    }

    public int getUnlimitedRowCount() {
        return this.linesOnFile;
    }

    public int getLimitedRowCount() {
        if (this.linesOnFile > this.rowLimit) {
            return this.rowLimit;
        }
        return this.linesOnFile;
    }

    public void setNormalised(boolean isNormalised) {
        this.isNormalised = isNormalised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(ProgressInformator informator) throws FileNotFoundException, IOException {
        this.createOutputFiles(this.screen.getColumnTypeManager().getChipCount());
        this.initializeReader();
        ArrayList<PrintWriter> outputWriters = new ArrayList<PrintWriter>();
        for (File outputFile : this.getOutputFiles()) {
            FileOutputStream outStream = new FileOutputStream(outputFile);
            outputWriters.add(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outStream))));
        }
        informator.setMinimunValue(0);
        informator.setMaximumValue(this.linesOnFile);
        String OUTPUT_DELIM = "\t";
        try {
            String[] splittedLine;
            List<DataColumn> columns = this.screen.getColumnTypeManager().getColumns();
            boolean[] isFirst = new boolean[this.screen.getColumnTypeManager().getChipCount()];
            for (int i = 0; i < isFirst.length; ++i) {
                isFirst[i] = true;
            }
            boolean isUniqueTitles = false;
            if (this.isNormalised) {
                isUniqueTitles = this.isUniqueTitles(this.columnsFilterByType(columns, ColumnType.SAMPLE_LABEL));
            }
            for (DataColumn column : columns) {
                ColumnType type = column.getColumnType();
                if (type == null || type.equals((Object)ColumnType.UNUSED_LABEL) || type.equals((Object)ColumnType.ROW_NUMBER)) continue;
                if (type.equals((Object)ColumnType.ANNOTATION_LABEL) || type.equals((Object)ColumnType.IDENTIFIER_LABEL)) {
                    for (int chip = 0; chip < outputWriters.size(); ++chip) {
                        if (isFirst[chip]) {
                            isFirst[chip] = false;
                        } else {
                            ((PrintWriter)outputWriters.get(chip)).print(OUTPUT_DELIM);
                        }
                        if (this.isNormalised) {
                            if (type.equals((Object)ColumnType.IDENTIFIER_LABEL)) {
                                ((PrintWriter)outputWriters.get(chip)).print(" ");
                                continue;
                            }
                            ((PrintWriter)outputWriters.get(chip)).print(column.getOriginalName());
                            continue;
                        }
                        ((PrintWriter)outputWriters.get(chip)).print(type.getTitle());
                    }
                    continue;
                }
                if (this.isNormalised) {
                    if (isFirst[0]) {
                        isFirst[0] = false;
                    } else {
                        ((PrintWriter)outputWriters.get(0)).print(OUTPUT_DELIM);
                    }
                    int chipNumber = isUniqueTitles ? -1 : column.getChipNumber();
                    ((PrintWriter)outputWriters.get(0)).print(this.convertToNormalised(column.getOriginalName(), chipNumber, column.getColumnType()));
                    continue;
                }
                if (isFirst[column.getChipNumber() - 1]) {
                    isFirst[column.getChipNumber() - 1] = false;
                } else {
                    ((PrintWriter)outputWriters.get(column.getChipNumber() - 1)).print(OUTPUT_DELIM);
                }
                ((PrintWriter)outputWriters.get(column.getChipNumber() - 1)).print(type.getTitle());
            }
            for (PrintWriter output : outputWriters) {
                output.print("\n");
            }
            while ((splittedLine = this.nextLine(true, true)) != null) {
                int columnNumber = 0;
                for (int i = 0; i < isFirst.length; ++i) {
                    isFirst[i] = true;
                }
                for (DataColumn column : columns) {
                    ColumnType type = column.getColumnType();
                    if (type.equals((Object)ColumnType.UNUSED_LABEL)) {
                        ++columnNumber;
                        continue;
                    }
                    if (type.equals((Object)ColumnType.ROW_NUMBER)) continue;
                    if (type.equals((Object)ColumnType.ANNOTATION_LABEL) || type.equals((Object)ColumnType.IDENTIFIER_LABEL)) {
                        for (int chip = 0; chip < outputWriters.size(); ++chip) {
                            this.writeSplittedLineToChipFile(chip, columnNumber, isFirst, splittedLine, (PrintWriter)outputWriters.get(chip), type);
                        }
                    } else if (this.isNormalised) {
                        this.writeSplittedLineToChipFile(column.getChipNumber() - 1, columnNumber, isFirst, splittedLine, (PrintWriter)outputWriters.get(0), type);
                    } else {
                        this.writeSplittedLineToChipFile(column.getChipNumber() - 1, columnNumber, isFirst, splittedLine, (PrintWriter)outputWriters.get(column.getChipNumber() - 1), type);
                    }
                    ++columnNumber;
                }
                for (PrintWriter output : outputWriters) {
                    output.print("\n");
                }
                if (this.lineNumber % this.getInformationInterval() != 0) continue;
                informator.setValue(this.lineNumber);
            }
        }
        catch (ClosedByInterruptException cbie) {
        }
        catch (Exception e) {
            this.application.reportException(e);
        }
        finally {
            for (PrintWriter output : outputWriters) {
                if (output == null) continue;
                output.close();
            }
            this.buf.close();
            this.choppedDataMatrix = null;
            informator.setValue(0);
        }
    }

    private List<DataColumn> columnsFilterByType(List<DataColumn> columns, ColumnType type) {
        ArrayList<DataColumn> filteredCols = new ArrayList<DataColumn>();
        for (DataColumn col : columns) {
            if (col.getColumnType() != type) continue;
            filteredCols.add(col);
        }
        return filteredCols;
    }

    private boolean isUniqueTitles(List<DataColumn> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            for (int j = i + 1; j < columns.size(); ++j) {
                if (!columns.get(i).getOriginalName().equals(columns.get(j).getOriginalName())) continue;
                return false;
            }
        }
        return true;
    }

    private String convertToNormalised(String title, int chipNumber, ColumnType columnType) {
        String newTitle = "";
        if (columnType == ColumnType.SAMPLE_LABEL) {
            if (!title.startsWith(SAMPLE_START)) {
                newTitle = newTitle + SAMPLE_START;
            }
            newTitle = newTitle + title;
            if (chipNumber > 0) {
                String numberString = "000";
                numberString = numberString + chipNumber;
                newTitle = newTitle + numberString.substring(numberString.length() - 3);
            }
        } else {
            this.application.reportException(new IllegalArgumentException("Only sample columns can be converted for now"));
        }
        return newTitle;
    }

    public void setHeaderEndsRow(int row) {
        this.headerEnd = row;
        this.fireHeaderChangeEvent(new HeaderChangedEvent((Object)this, row));
    }

    public void setFooterBeginsRow(int row) {
        this.footerStart = row;
        this.fireFooterChangeEvent(new FooterChangedEvent((Object)this, row));
    }

    public boolean hasHeader() {
        return this.getHeaderEnd() >= 0;
    }

    public boolean hasFooter() {
        return this.getFooterStart() != Integer.MAX_VALUE;
    }

    public void setColumnTitleLine(int row) {
        this.columnTitleLine = row;
        if (row < 0) {
            this.columnTitles = null;
            logger.debug("Column titles set to null");
        } else {
            String[] columns = new String[this.getLimitedColumnCount()];
            for (int i = 1; i < columns.length && i < this.columnLimit; ++i) {
                columns[i - 1] = i < this.choppedDataMatrix[row].length ? this.choppedDataMatrix[row][i].toString() : " ";
            }
            this.setColumnTitles(columns);
            logger.debug("Column titles set. Column count is " + this.columnTitles.length);
        }
        this.fireTitleRowChangeEvent(new TitleRowChangedEvent((Object)this, row));
    }

    private void setColumnTitles(String[] columns) {
        int i;
        if (columns.equals(this.columnTitles)) {
            return;
        }
        int columnTitlesLength = columns.length + 1 > this.columnLimit ? this.columnLimit : columns.length + 1;
        this.columnTitles = new String[columnTitlesLength];
        this.cleanColumnTitles = new String[columnTitlesLength];
        this.cleanColumnTitles[0] = " ";
        for (i = 1; i < this.cleanColumnTitles.length; ++i) {
            this.cleanColumnTitles[i] = columns[i - 1];
        }
        for (i = 1; i < this.columnTitles.length; ++i) {
            this.columnTitles[i] = "" + i + " - " + this.cleanColumnTitles[i];
        }
        this.fireColumnTitlesChangeEvent(new ColumnTitlesChangedEvent((Object)this, this.columnTitles));
    }

    public void setLimits(int rowLimit, int columnLimit) {
        boolean columnChanged = this.columnLimit != columnLimit;
        this.columnLimit = columnLimit;
        this.rowLimit = rowLimit;
        if (columnChanged && this.columnTitles == null) {
            this.fireColumnTitlesChangeEvent(new ColumnTitlesChangedEvent((Object)this, this.getDefaultColumnTitles()));
        }
    }

    public String[] getColumnTitles() {
        if (this.columnTitles != null) {
            logger.debug("Got the predefined column titles. Column count is " + this.getLimitedColumnCount());
            return this.columnTitles;
        }
        logger.debug("Got default column titles. Column count is " + this.getLimitedColumnCount());
        return this.getDefaultColumnTitles();
    }

    public String[] getCleanColumnTitles() {
        return this.cleanColumnTitles;
    }

    public String getCleanColumnTitle(int index) {
        if (this.cleanColumnTitles != null && this.cleanColumnTitles.length >= index) {
            return this.cleanColumnTitles[index];
        }
        return null;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
        this.fireInputFileChangeEvent(new InputFileChangedEvent((Object)this, inputFile));
    }

    public boolean hasColumnTitles() {
        return this.columnTitleLine >= 0;
    }

    private String[] nextLine(boolean ignoreHeadersAndFooters, boolean ignoreLimits) throws IOException, ClosedByInterruptException {
        String nextLine = null;
        while ((nextLine = this.buf.readLine()) != null && !Thread.interrupted()) {
            if (nextLine.equals("")) continue;
            if (!ignoreLimits && this.linesRead >= this.rowLimit) {
                return null;
            }
            if (this.lineNumber == this.columnTitleLine) {
                this.setColumnTitles(nextLine.split(this.delim.toString()));
                logger.debug("Column title line found. Count of columns: " + nextLine.split(this.delim.toString()).length);
                ++this.lineNumber;
                if (ignoreHeadersAndFooters) continue;
                ++this.linesRead;
                return nextLine.split(this.delim.toString());
            }
            if (ignoreHeadersAndFooters && this.headerEnd > -1 && this.lineNumber <= this.headerEnd) {
                ++this.lineNumber;
                continue;
            }
            if (ignoreHeadersAndFooters && this.footerStart > -1 && this.lineNumber >= this.footerStart) {
                ++this.lineNumber;
                continue;
            }
            ++this.lineNumber;
            ++this.linesRead;
            return nextLine.split(this.delim.toString());
        }
        return null;
    }

    @Override
    public void addConversionChangeListener(ConversionModelChangeListener l) {
        this.conversionListeners.add(l);
    }

    @Override
    public void removeConversionChangeListener(ConversionModelChangeListener l) {
        this.conversionListeners.remove(l);
    }

    @Override
    public void fireDecimalSeparatorChangeEvent(DecimalSeparatorChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.decimalSeparatorChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    @Override
    public void fireDelimiterChangeEvent(DelimiterChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.delimiterChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    @Override
    public void fireFooterChangeEvent(FooterChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.footerChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    @Override
    public void fireHeaderChangeEvent(HeaderChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.headerChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    @Override
    public void fireTitleRowChangeEvent(TitleRowChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.titleRowChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    @Override
    public void fireColumnTitlesChangeEvent(ColumnTitlesChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.columnTitlesChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    @Override
    public void fireInputFileChangeEvent(InputFileChangedEvent event) {
        for (ConversionModelChangeListener listener : this.conversionListeners) {
            listener.inputFileChanged(event);
        }
        logger.debug("Fired event " + event);
    }

    public void createOutputFiles(int chipCount) throws IOException {
        if (this.outputFiles != null) {
            this.outputFiles.clear();
        } else {
            this.outputFiles = new ArrayList<File>();
        }
        String originalFileName = this.inputFile.getName().replaceAll("\\.[^.]*$", "");
        if (chipCount > 1 && !this.isNormalised) {
            List<String> columns = this.screen.getColumnTypeManager().getOriginalChipNames();
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = columns.get(i);
                if (columnName == null) {
                    columnName = originalFileName + "_" + (i + 1);
                }
                String fileName = columnName + " (";
                String suffix = ").tsv";
                this.outputFiles.add(ImportUtils.createTempFile(fileName, suffix));
            }
        } else {
            String suffix = ").tsv";
            this.outputFiles.add(ImportUtils.createTempFile(originalFileName + " (", suffix));
        }
    }

    public List<File> getOutputFiles() {
        return this.outputFiles;
    }

    private void writeSplittedLineToChipFile(int chip, int columnNumber, boolean[] isFirst, String[] splittedLine, PrintWriter outputWriter, ColumnType type) {
        String OUTPUT_DELIM = "\t";
        if (this.isNormalised) {
            chip = 0;
        }
        if (isFirst[chip]) {
            isFirst[chip] = false;
        } else {
            outputWriter.print(OUTPUT_DELIM);
        }
        String dataToWrite = columnNumber >= splittedLine.length ? "" : splittedLine[columnNumber].toString();
        dataToWrite = this.screen.getFlagTrimmer().doTrimming(dataToWrite, columnNumber + 1);
        dataToWrite = this.screen.getDataTrimmer().doTrimming(dataToWrite, columnNumber + 1);
        if (type.isNumeric()) {
            dataToWrite = dataToWrite.replace(this.decimalSeparator, '.');
        }
        outputWriter.print(dataToWrite);
    }

    public String getInputFileName() {
        if (this.inputFile != null) {
            return this.inputFile.getName();
        }
        return null;
    }
}

