/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.auth.AuthenticationProvider;
import fi.csc.microarray.auth.AuthorisationException;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.AuthenticationMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.security.SecureSessionPool;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.MemUtil;
import java.util.Arrays;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class Authenticator
extends NodeBase
implements ShutdownCallback {
    private static Logger logger = null;
    private static Logger securityLogger = null;
    private static Logger messageLogger = null;
    private SecureSessionPool sessionPool = new SecureSessionPool();
    private MessagingEndpoint endpoint;
    private MessagingTopic authorisedTopic;
    private MessagingTopic authorisedUrlTopic;
    private MessagingTopic testTopic;
    private TestListener testListener;
    private AuthenticationProvider authenticationProvider;

    public Authenticator() throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList(new String[0]));
        logger = Logger.getLogger(Authenticator.class);
        securityLogger = Logger.getLogger("security.frontend");
        messageLogger = Logger.getLogger("messages.frontend");
        this.endpoint = new MessagingEndpoint(this);
        this.authorisedTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.authorisedUrlTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_URL_TOPIC, MessagingTopic.AccessMode.WRITE);
        RequestListener jobListener = new RequestListener(this.authorisedTopic);
        MessagingTopic requestTopic = this.endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        requestTopic.setListener(jobListener);
        RequestListener urlListener = new RequestListener(this.authorisedUrlTopic);
        MessagingTopic urlTopic = this.endpoint.createTopic(Topics.Name.URL_TOPIC, MessagingTopic.AccessMode.READ);
        urlTopic.setListener(urlListener);
        this.testTopic = this.endpoint.createTopic(Topics.Name.TEST_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
        this.testListener = new TestListener();
        this.testTopic.setListener(this.testListener);
        this.authenticationProvider = new JaasAuthenticationProvider();
        KeepAliveShutdownHandler.init(this);
        logger.info("authenticator is up and running [" + ApplicationConstants.NAMI_VERSION + "]");
        logger.info("[mem: " + MemUtil.getMemInfo() + "]");
    }

    public String getName() {
        return "authenticator";
    }

    public void shutdown() {
        logger.info("shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error("closing messaging endpoint failed", e);
        }
        logger.info("shutting down");
    }

    private class TestListener
    implements MessagingListener {
        private TestListener() {
        }

        public void onNamiMessage(NamiMessage msg) {
            logger.debug("got message on test-topic.");
            try {
                Destination dest = msg.getReplyTo();
                if (dest != null) {
                    CommandMessage replyMessage = new CommandMessage("OK");
                    Authenticator.this.endpoint.replyToMessage(msg, (NamiMessage)replyMessage);
                } else {
                    logger.debug("ReplyTo is null, so no reply was sent.");
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private class RequestListener
    implements MessagingListener {
        private static final String KEY_PENDING_MESSAGE = "pending-message";
        private static final String KEY_USERNAME = "username";
        private MessagingTopic routeTo;

        public RequestListener(MessagingTopic routeTo) {
            this.routeTo = routeTo;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onNamiMessage(NamiMessage msg) {
            try {
                logger.debug("starting to process " + msg);
                NamiMessage messageToBeRouted = null;
                SecureSessionPool.Session session = null;
                if (msg.getSessionID() != null) {
                    String id = msg.getSessionID();
                    if (Authenticator.this.sessionPool.getSession(id) != null) {
                        session = Authenticator.this.sessionPool.getSession(id);
                        logger.debug("message " + msg.getMessageID() + " had a proper session " + session.getID());
                    }
                }
                if (session == null) {
                    logger.debug("message " + msg + " has no session, requires authentication");
                    session = Authenticator.this.sessionPool.createSession();
                    logger.debug("created new session, pool size is now " + Authenticator.this.sessionPool.size());
                    session.putParameter(KEY_PENDING_MESSAGE, msg);
                    this.requestAuthentication(msg, session.getID().toString());
                } else {
                    if (msg instanceof AuthenticationMessage) {
                        AuthenticationMessage authMsg = (AuthenticationMessage)msg;
                        if (!authMsg.isLogin()) {
                            if (!authMsg.isLogout()) throw new IllegalArgumentException("unknown authentication message: " + authMsg);
                            logger.debug("message " + msg.getMessageID() + " is a logout");
                            Authenticator.this.sessionPool.removeSession(session);
                            return;
                        }
                        messageLogger.debug("message " + authMsg.getMessageID() + " is a login");
                        if (!Authenticator.this.authenticationProvider.authenticate(authMsg.getUsername(), authMsg.getPassword().toCharArray())) {
                            securityLogger.info("illegal username/password (user " + authMsg.getUsername() + ", auth. message JMS id was " + authMsg.getJmsMessageID() + ")");
                            this.ackLogin(authMsg, session.getID().toString(), false);
                            return;
                        }
                        this.ackLogin(authMsg, session.getID().toString(), true);
                        session.putParameter(KEY_USERNAME, authMsg.getUsername());
                        authMsg.setSessionID(session.getID().toString());
                        securityLogger.info("authenticated user " + authMsg.getUsername() + " (auth. message JMS id was " + authMsg.getJmsMessageID() + ")");
                        if (session.getParameter(KEY_PENDING_MESSAGE) != null) {
                            messageToBeRouted = (NamiMessage)session.getParameter(KEY_PENDING_MESSAGE);
                        }
                    } else {
                        messageToBeRouted = msg;
                    }
                    session.touch();
                }
                if (messageToBeRouted == null) return;
                securityLogger.info("message " + messageToBeRouted.getMessageID() + " was allowed");
                messageLogger.info(messageToBeRouted);
                messageToBeRouted.setUsername((String)session.getParameter(KEY_USERNAME));
                this.routeTo.sendMessage(messageToBeRouted);
                securityLogger.info("routing message " + messageToBeRouted.getMessageID() + " to authorised topic");
                return;
            }
            catch (JMSException e) {
                logger.error(e);
                return;
            }
            catch (AuthorisationException e) {
                securityLogger.info("authorisation failed: " + e.getMessage());
                logger.info(e);
            }
        }

        private void ackLogin(NamiMessage loginMessage, String sessionID, boolean succeeded) throws JMSException, AuthorisationException {
            AuthenticationMessage.AuthenticationOperation operation = succeeded ? AuthenticationMessage.AuthenticationOperation.LOGIN_SUCCEEDED : AuthenticationMessage.AuthenticationOperation.LOGIN_FAILED;
            AuthenticationMessage request = new AuthenticationMessage(operation);
            request.setSessionID(sessionID);
            request.setReplyTo(loginMessage.getReplyTo());
            Authenticator.this.endpoint.replyToMessage(loginMessage, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }

        private void requestAuthentication(NamiMessage msg, String sessionID) throws JMSException, AuthorisationException {
            AuthenticationMessage request = new AuthenticationMessage(AuthenticationMessage.AuthenticationOperation.REQUEST);
            request.setSessionID(sessionID);
            request.setReplyTo(msg.getReplyTo());
            logger.debug("requesting authentication for " + msg.getMessageID() + " under the session " + sessionID);
            Authenticator.this.endpoint.replyToMessage(msg, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }
    }
}

