/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.exception.MicroarrayException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class VVSADLTool {
    private static String COMMENT = "#";

    public ParsedRScript parseRScript(InputStream rScriptSource, String commentString) throws MicroarrayException {
        String comment = commentString == null || commentString.equals("") ? COMMENT : commentString;
        ParsedRScript parsedScript = new ParsedRScript();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(rScriptSource));
            boolean inHeaderCommentBlock = true;
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith(comment)) {
                    inHeaderCommentBlock = false;
                }
                if (inHeaderCommentBlock) {
                    parsedScript.VVSADL = parsedScript.VVSADL + line.substring(comment.length());
                }
                parsedScript.rSource = parsedScript.rSource + line + "\n";
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new MicroarrayException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return parsedScript;
    }

    public ParsedRScript parseRScript(InputStream scriptSource) throws MicroarrayException {
        return this.parseRScript(scriptSource, COMMENT);
    }

    public static class ParsedRScript {
        public String VVSADL = "";
        public String rSource = "";
    }
}

