/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolRepository;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.MemUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class AnalyserServer
extends MonitoredNodeBase
implements MessagingListener,
ResultCallback,
ShutdownCallback {
    public static final String DESCRIPTION_OUTPUT_NAME = "description";
    public static final String SOURCECODE_OUTPUT_NAME = "sourcecode";
    private static Logger logger;
    private static Logger loggerJobs;
    private static Logger loggerStatus;
    private int receiveTimeout;
    private int scheduleTimeout;
    private int timeoutCheckInterval;
    private boolean sweepWorkDir;
    private int maxJobs;
    private String id = UUID.randomUUID().toString();
    private File workDir;
    private ToolRepository toolRepository;
    private MessagingEndpoint endpoint;
    private MessagingTopic managerTopic;
    private FileBrokerClient fileBroker;
    private ExecutorService executorService;
    private Object jobsLock = new Object();
    private LinkedHashMap<String, AnalysisJob> receivedJobs = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisJob> scheduledJobs = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisJob> runningJobs = new LinkedHashMap();
    Timer timeoutTimer;

    public AnalyserServer() throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("comp"));
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        this.receiveTimeout = configuration.getInt("comp", "receive-timeout");
        this.scheduleTimeout = configuration.getInt("comp", "schedule-timeout");
        this.timeoutCheckInterval = configuration.getInt("comp", "timeout-check-interval");
        this.sweepWorkDir = configuration.getBoolean("comp", "sweep-work-dir");
        this.maxJobs = configuration.getInt("comp", "max-jobs");
        logger = Logger.getLogger(AnalyserServer.class);
        loggerJobs = Logger.getLogger("jobs");
        loggerStatus = Logger.getLogger("status");
        logger.info("starting compute service...");
        this.workDir = DirectoryLayout.getInstance().getJobsDataDirBase(this.id);
        DirectoryLayout.getInstance().getCustomScriptsDir();
        this.executorService = Executors.newCachedThreadPool();
        this.toolRepository = new ToolRepository(this.workDir);
        this.timeoutTimer = new Timer(true);
        this.timeoutTimer.schedule((TimerTask)new TimeoutTimerTask(), this.timeoutCheckInterval, (long)this.timeoutCheckInterval);
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic analyseTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        analyseTopic.setListener(this);
        this.managerTopic = this.endpoint.createTopic(Topics.Name.MANAGER_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.fileBroker = new FileBrokerClient(this.endpoint.createTopic(Topics.Name.AUTHORISED_URL_TOPIC, MessagingTopic.AccessMode.WRITE));
        KeepAliveShutdownHandler.init(this);
        logger.info("analyser is up and running [" + ApplicationConstants.NAMI_VERSION + "]");
        logger.info("[mem: " + MemUtil.getMemInfo() + "]");
    }

    public String getName() {
        return "analyser";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNamiMessage(NamiMessage namiMessage) {
        if (namiMessage instanceof JobMessage) {
            JobMessage jobMessage = (JobMessage)namiMessage;
            if ("describe".equals(jobMessage.getAnalysisId())) {
                logger.info("sending all descriptions");
                this.sendReplyMessage(jobMessage, this.createDescriptionsMessage(jobMessage));
                return;
            }
            if ("describe-operation".equals(jobMessage.getAnalysisId())) {
                this.sendReplyMessage(jobMessage, this.createSourceCodeMessage(jobMessage));
                return;
            }
            this.receiveJob(jobMessage);
        } else if (namiMessage instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)namiMessage;
            if ("choose".equals(commandMessage.getCommand())) {
                String acceptedId = commandMessage.getNamedParameter("as-id");
                String jobId = commandMessage.getNamedParameter("job-id");
                logger.debug("ACCEPT_OFFER for analyser: " + acceptedId + " job: " + jobId);
                if (this.id.equals(acceptedId)) {
                    Object object = this.jobsLock;
                    synchronized (object) {
                        AnalysisJob job = this.scheduledJobs.get(commandMessage.getNamedParameter("job-id"));
                        if (job != null) {
                            this.scheduledJobs.remove(jobId);
                            this.runningJobs.put(job.getId(), job);
                            this.executorService.execute(job);
                            logger.info("Executing job " + job.analysis.getFullName() + ", " + job.getId() + ", " + job.getInputMessage().getUsername());
                        } else {
                            logger.warn("Got ACCEPT_OFFER for job which is not scheduled.");
                        }
                    }
                } else {
                    logger.debug("Removing scheduled job " + jobId);
                    Object object = this.jobsLock;
                    synchronized (object) {
                        AnalysisJob jobToBeForgotten = (AnalysisJob)this.receivedJobs.remove(jobId);
                        if (jobToBeForgotten != null) {
                            this.receivedJobs.remove(jobToBeForgotten);
                        } else {
                            this.scheduledJobs.remove(jobId);
                            this.activeJobRemoved();
                        }
                    }
                }
            } else if ("cancel".equals(commandMessage.getCommand())) {
                AnalysisJob job;
                String jobId = commandMessage.getParameters().get(0);
                Object object = this.jobsLock;
                synchronized (object) {
                    job = this.receivedJobs.containsKey(jobId) ? (AnalysisJob)this.receivedJobs.remove(jobId) : (this.scheduledJobs.containsKey(jobId) ? (AnalysisJob)this.scheduledJobs.remove(jobId) : this.runningJobs.get(jobId));
                }
                if (job != null) {
                    job.cancel();
                }
            }
            this.updateStatus();
        } else {
            logger.error("unidentified message: " + namiMessage.getMessageID());
        }
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public boolean shouldSweepWorkDir() {
        return this.sweepWorkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunningJob(AnalysisJob job) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            logger.warn("Could not get local hostname.");
            hostname = "";
        }
        char delimiter = ';';
        loggerJobs.info(job.getId() + delimiter + job.getInputMessage().getAnalysisId().replaceAll("\"", "") + delimiter + (Object)((Object)job.getState()) + delimiter + job.getInputMessage().getUsername() + delimiter + job.getExecutionStartTime().toString() + delimiter + job.getExecutionEndTime().toString() + delimiter + hostname);
        logger.debug("Analyser server removing job " + job.getId() + "(" + (Object)((Object)job.getState()) + ")");
        Object object = this.jobsLock;
        synchronized (object) {
            this.runningJobs.remove(job.getId());
        }
        this.activeJobRemoved();
        this.sendJobLogMessage(job);
    }

    public void sendJobLogMessage(AnalysisJob job) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            logger.warn("Could not get local hostname.");
            hostname = "";
        }
        JobLogMessage jobLogMessage = new JobLogMessage(job.getInputMessage().getAnalysisId().replaceAll("\"", ""), job.getState(), job.getId(), job.getExecutionStartTime(), job.getExecutionEndTime(), job.getResultMessage().getErrorMessage(), job.getResultMessage().getOutputText(), job.getInputMessage().getUsername(), hostname);
        try {
            this.managerTopic.sendMessage(jobLogMessage);
        }
        catch (JMSException e) {
            logger.error("Could not send job log message.", e);
        }
    }

    public void sendResultMessage(NamiMessage original, ResultMessage reply) {
        try {
            this.endpoint.replyToMessage(original, (NamiMessage)reply);
        }
        catch (JMSException e) {
            logger.error("Could not send ResultMessage " + reply.getMessageID());
        }
        logger.info("result message sent (" + reply.getMessageID() + " " + (Object)((Object)reply.getState()) + ")");
    }

    public FileBrokerClient getFileBrokerClient() {
        return this.fileBroker;
    }

    private void sendReplyMessage(final NamiMessage original, final NamiMessage reply) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    AnalyserServer.this.endpoint.replyToMessage(original, reply);
                }
                catch (JMSException e) {
                    logger.error("Could not send message.", e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJobRemoved() {
        Object object = this.jobsLock;
        synchronized (object) {
            if (!this.receivedJobs.isEmpty() && this.runningJobs.size() + this.scheduledJobs.size() < this.maxJobs) {
                AnalysisJob job = this.receivedJobs.values().iterator().next();
                this.receivedJobs.remove(job.getId());
                this.scheduleJob(job);
            }
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveJob(JobMessage jobMessage) {
        AnalysisJob job;
        AnalysisDescription description = null;
        try {
            description = this.toolRepository.getDescription(jobMessage.getAnalysisId());
        }
        catch (AnalysisException e) {
            logger.warn("Could not fetch description for " + jobMessage.getAnalysisId());
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Could not load operation.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        if (description == null) {
            logger.info("Analysis " + jobMessage.getAnalysisId() + " not found.");
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Operation not found.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        if (!this.toolRepository.supports(description.getFullName())) {
            logger.debug("Analysis " + jobMessage.getAnalysisId() + " ( " + description.getSourceResourceName() + " ) not supported, ignoring request.");
            return;
        }
        try {
            job = description.createAnalysisJob(jobMessage, this);
        }
        catch (AnalysisException e) {
            logger.warn("could not create analysis job for " + jobMessage.getAnalysisId());
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Could not initialise operation.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        Object object = this.jobsLock;
        synchronized (object) {
            job.setReceiveTime(new Date());
            if (this.runningJobs.size() + this.scheduledJobs.size() < this.maxJobs) {
                this.scheduleJob(job);
            } else {
                this.receivedJobs.put(job.getId(), job);
                try {
                    this.sendAckMessage(job);
                }
                catch (Exception e) {
                    this.receivedJobs.remove(job.getId());
                    logger.error("Could not send ACK for job " + job.getId());
                }
            }
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(AnalysisJob job) {
        Object object = this.jobsLock;
        synchronized (object) {
            job.setScheduleTime(new Date());
            this.scheduledJobs.put(job.getId(), job);
        }
        try {
            this.sendOfferMessage(job);
        }
        catch (Exception e) {
            Object object2 = this.jobsLock;
            synchronized (object2) {
                this.scheduledJobs.remove(job.getId());
            }
            logger.error("Could not send OFFER for job " + job.getId());
        }
        this.updateStatus();
    }

    private void sendAckMessage(AnalysisJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("acknowledge");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        this.sendReplyMessage(job.getInputMessage(), offerMessage);
    }

    private void sendOfferMessage(AnalysisJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("offer");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        this.sendReplyMessage(job.getInputMessage(), offerMessage);
    }

    private ResultMessage createDescriptionsMessage(JobMessage requestMessage) {
        ResultMessage resultMessage = new ResultMessage("", JobState.COMPLETED, "", "", "", requestMessage.getReplyTo());
        try {
            String description = this.toolRepository.serialiseAsStringBuffer().toString();
            URL url = this.fileBroker.addFile(new ByteArrayInputStream(description.getBytes()), null);
            resultMessage.addPayload(DESCRIPTION_OUTPUT_NAME, url);
        }
        catch (Exception e) {
            logger.error("Could not send analysis descriptions", e);
            resultMessage.setState(JobState.ERROR);
            resultMessage.setErrorMessage("Could not send analysis descriptions.");
        }
        return resultMessage;
    }

    private ResultMessage createSourceCodeMessage(JobMessage requestMessage) {
        ResultMessage resultMessage = new ResultMessage("", JobState.COMPLETED, "", "", "", requestMessage.getReplyTo());
        try {
            String name = new String(requestMessage.getParameters().get(0));
            logger.info("sending source code for " + name);
            String sourceCode = this.toolRepository.getDescription(name).getSourceCode();
            byte[] bytes = sourceCode.getBytes();
            if (bytes.length == 0) {
                bytes = "<empty source code>".getBytes();
            }
            URL url = this.fileBroker.addFile(new ByteArrayInputStream(bytes), null);
            resultMessage.addPayload(SOURCECODE_OUTPUT_NAME, url);
        }
        catch (Exception e) {
            logger.error("Could not send analysis source code", e);
            resultMessage.setState(JobState.ERROR);
            resultMessage.setErrorMessage("Could not send analysis source code.");
        }
        return resultMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.jobsLock;
        synchronized (object) {
            loggerStatus.info("received jobs: " + this.receivedJobs.size() + ", scheduled jobs: " + this.scheduledJobs.size() + ", running jobs: " + this.runningJobs.size());
        }
    }

    public void shutdown() {
        logger.info("shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error("closing messaging endpoint failed", e);
        }
        logger.info("shutting down");
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = AnalyserServer.this.jobsLock;
            synchronized (object) {
                ArrayList<AnalysisJob> jobsToBeRemoved = new ArrayList<AnalysisJob>();
                for (AnalysisJob job : AnalyserServer.this.receivedJobs.values()) {
                    if (System.currentTimeMillis() - (long)(AnalyserServer.this.receiveTimeout * 1000) <= job.getReceiveTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (AnalysisJob job : jobsToBeRemoved) {
                    AnalyserServer.this.receivedJobs.remove(job.getId());
                    logger.debug("Removing old received job: " + job.getId());
                    logger.debug("Jobs received: " + AnalyserServer.this.receivedJobs.size() + ", scheduled: " + AnalyserServer.this.scheduledJobs.size() + ", running: " + AnalyserServer.this.runningJobs.size());
                }
                jobsToBeRemoved.clear();
                for (AnalysisJob job : AnalyserServer.this.scheduledJobs.values()) {
                    if (System.currentTimeMillis() - (long)(AnalyserServer.this.scheduleTimeout * 1000) <= job.getScheduleTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (AnalysisJob job : jobsToBeRemoved) {
                    AnalyserServer.this.scheduledJobs.remove(job.getId());
                    logger.debug("Removing old scheduled job: " + job.getId());
                    AnalyserServer.this.activeJobRemoved();
                    logger.debug("Jobs received: " + AnalyserServer.this.receivedJobs.size() + ", scheduled: " + AnalyserServer.this.scheduledJobs.size() + ", running: " + AnalyserServer.this.runningJobs.size());
                }
            }
        }
    }
}

