/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.AlwaysTrueValueMatcher;
import it.sauronsoftware.cron4j.IntArrayValueMatcher;
import it.sauronsoftware.cron4j.InvalidPatternException;
import it.sauronsoftware.cron4j.ValueMatcher;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

class SchedulingPattern {
    private static String[] MONTHS = new String[]{"", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static String[] DAYS_OF_WEEK = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    private String originalString;
    protected ArrayList minuteMatchers = new ArrayList<E>();
    protected ArrayList hourMatchers = new ArrayList<E>();
    protected ArrayList dayOfMonthMatchers = new ArrayList<E>();
    protected ArrayList monthMatchers = new ArrayList<E>();
    protected ArrayList dayOfWeekMatchers = new ArrayList<E>();
    protected int matcherSize = 0;

    /*
     * Unable to fully structure code
     */
    public SchedulingPattern(String pattern) throws InvalidPatternException {
        super();
        this.originalString = pattern;
        st1 = new StringTokenizer(pattern, "|");
        if (st1.countTokens() >= 1) ** GOTO lbl27
        throw new InvalidPatternException();
lbl-1000:
        // 1 sources

        {
            localPattern = st1.nextToken();
            st2 = new StringTokenizer(localPattern, " \t");
            if (st2.countTokens() != 5) {
                throw new InvalidPatternException();
            }
            this.minuteMatchers.add(this.buildValueMatcher(st2.nextToken(), 0, 59, null));
            this.hourMatchers.add(this.buildValueMatcher(st2.nextToken(), 0, 23, null));
            this.dayOfMonthMatchers.add(this.buildValueMatcher(st2.nextToken(), 1, 31, null));
            this.monthMatchers.add(this.buildValueMatcher(st2.nextToken(), 1, 12, SchedulingPattern.MONTHS));
            this.dayOfWeekMatchers.add(this.buildValueMatcher(st2.nextToken(), 0, 6, SchedulingPattern.DAYS_OF_WEEK));
            ++this.matcherSize;
lbl27:
            // 2 sources

            ** while (st1.hasMoreTokens())
        }
lbl28:
        // 1 sources

    }

    private ValueMatcher buildValueMatcher(String str, int minValue, int maxValue, String[] stringEquivalents) throws InvalidPatternException {
        if (str.length() == 1 && str.equals("*")) {
            return new AlwaysTrueValueMatcher();
        }
        StringTokenizer st = new StringTokenizer(str, "/");
        int tokens = st.countTokens();
        if (tokens < 1 || tokens > 2) {
            throw new InvalidPatternException();
        }
        ArrayList list = this.buildPart1(st.nextToken(), minValue, maxValue, stringEquivalents);
        if (tokens == 2) {
            list = this.buildPart2(list, st.nextToken(), minValue, maxValue);
        }
        return new IntArrayValueMatcher(list);
    }

    private ArrayList buildPart1(String str, int minValue, int maxValue, String[] stringEquivalents) throws InvalidPatternException {
        if (str.length() == 1 && str.equals("*")) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int i = minValue;
            while (i <= maxValue) {
                ret.add(new Integer(i));
                ++i;
            }
            return ret;
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        if (st.countTokens() < 1) {
            throw new InvalidPatternException();
        }
        ArrayList list = new ArrayList();
        while (st.hasMoreTokens()) {
            ArrayList list2 = this.buildPart1_1(st.nextToken(), minValue, maxValue, stringEquivalents);
            int size = list2.size();
            int i = 0;
            while (i < size) {
                list.add(list2.get(i));
                ++i;
            }
        }
        return list;
    }

    private ArrayList buildPart1_1(String str, int minValue, int maxValue, String[] stringEquivalents) throws InvalidPatternException {
        int value1;
        StringTokenizer st = new StringTokenizer(str, "-");
        int tokens = st.countTokens();
        if (tokens < 1 || tokens > 2) {
            throw new InvalidPatternException();
        }
        String str1 = st.nextToken();
        try {
            value1 = Integer.parseInt(str1);
        }
        catch (NumberFormatException e) {
            if (stringEquivalents != null) {
                try {
                    value1 = this.getIntValue(str1, stringEquivalents);
                }
                catch (Exception e1) {
                    throw new InvalidPatternException();
                }
            }
            throw new InvalidPatternException();
        }
        if (value1 < minValue || value1 > maxValue) {
            throw new InvalidPatternException();
        }
        int value2 = value1;
        if (tokens == 2) {
            String str2 = st.nextToken();
            try {
                value2 = Integer.parseInt(str2);
            }
            catch (NumberFormatException e) {
                if (stringEquivalents != null) {
                    try {
                        value2 = this.getIntValue(str2, stringEquivalents);
                    }
                    catch (Exception e1) {
                        throw new InvalidPatternException();
                    }
                }
                throw new InvalidPatternException();
            }
            if (value2 < minValue || value2 > maxValue || value2 <= value1) {
                throw new InvalidPatternException();
            }
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = value1;
        while (i <= value2) {
            Integer aux = new Integer(i);
            if (!list.contains(aux)) {
                list.add(aux);
            }
            ++i;
        }
        return list;
    }

    private ArrayList buildPart2(ArrayList list, String p2, int minValue, int maxValue) throws InvalidPatternException {
        int div = 0;
        try {
            div = Integer.parseInt(p2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (div <= minValue || div >= maxValue) {
            throw new InvalidPatternException();
        }
        int size = list.size();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            Integer aux = (Integer)list.get(i);
            if (aux % div == 0) {
                list2.add(aux);
            }
            ++i;
        }
        return list2;
    }

    private int getIntValue(String value, String[] values) throws Exception {
        int i = 0;
        while (i < values.length) {
            if (values[i].equalsIgnoreCase(value)) {
                return i;
            }
            ++i;
        }
        throw new Exception();
    }

    public boolean match(long millis) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(millis));
        int minute = gc.get(12);
        int hour = gc.get(11);
        int dayOfMonth = gc.get(5);
        int month = gc.get(2) + 1;
        int dayOfWeek = gc.get(7) - 1;
        int i = 0;
        while (i < this.matcherSize) {
            boolean eval;
            ValueMatcher minuteMatcher = (ValueMatcher)this.minuteMatchers.get(i);
            ValueMatcher hourMatcher = (ValueMatcher)this.hourMatchers.get(i);
            ValueMatcher dayOfMonthMatcher = (ValueMatcher)this.dayOfMonthMatchers.get(i);
            ValueMatcher monthMatcher = (ValueMatcher)this.monthMatchers.get(i);
            ValueMatcher dayOfWeekMatcher = (ValueMatcher)this.dayOfWeekMatchers.get(i);
            boolean bl = eval = minuteMatcher.match(minute) && hourMatcher.match(hour) && dayOfMonthMatcher.match(dayOfMonth) && monthMatcher.match(month) && dayOfWeekMatcher.match(dayOfWeek);
            if (eval) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getOriginalString() {
        return this.originalString;
    }
}

