/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VolumeTest
extends TestCase {
    protected static final int NUMBER = 1;
    private static final transient Log LOG = LogFactory.getLog(VolumeTest.class);
    protected Store store;
    protected String name;

    public void testListVolume() throws Exception {
        ListContainer container = this.store.getListContainer((Object)"volume");
        container.setMarshaller(Store.BYTES_MARSHALLER);
        byte[] data = new byte[10];
        for (int i = 0; i < 1; ++i) {
            container.add((Object)data);
            if (i % 100000 != 0) continue;
            LOG.error((Object)("persisted " + i));
        }
        int count = 0;
        Iterator i = container.iterator();
        while (i.hasNext()) {
            VolumeTest.assertNotNull(i.next());
            if (++count % 100000 != 0) continue;
            LOG.error((Object)("retrived  " + count));
        }
        VolumeTest.assertEquals((String)"Different retrieved to stored", (int)1, (int)count);
    }

    protected Store getStore() throws IOException {
        return StoreFactory.open((String)this.name, (String)"rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/volume-container.db";
        StoreFactory.delete((String)this.name);
        this.store = StoreFactory.open((String)this.name, (String)"rw");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
        }
        VolumeTest.assertTrue((boolean)StoreFactory.delete((String)this.name));
    }
}

